/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.exportation.table.TableExportParameters;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import fr.exemole.bdfserver.api.users.BdfUserPrefsEditor;
import fr.exemole.bdfserver.tools.exportation.table.TableExportParametersBuilder;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.List;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RedacteurDefaultTableExportParametersCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurDefaultTableExportParameters";
    public static final String COMMANDKEY = "_ USR-05";
    public static final String STATUSSHEET_PARAMNAME = "statussheet";
    private BdfUserPrefs redacBdfUserPrefs;
    private TableExportParameters tableExportParameters;
    private boolean withStatusSheet;

    public RedacteurDefaultTableExportParametersCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            BdfUserPrefsEditor bdfUserPrefsEditor = session.getBdfServerEditor().getBdfUserPrefsEditor(this.redacBdfUserPrefs).setDefaultHeaderType(this.tableExportParameters.getHeaderType()).putAttribute(AttributeBuilder.toAttribute(BdfUserSpace.TABLEEXPORT_PATTERNMODE_KEY, this.tableExportParameters.getDefaulFicheTableParameters().getPatternMode()));
            List<String> list = this.tableExportParameters.getDefaulFicheTableParameters().getWithList();
            boolean withDone = false;
            if (!list.isEmpty()) {
                AttributeBuilder builder = new AttributeBuilder(BdfUserSpace.TABLEEXPORT_WITH_KEY);
                for (String value : list) {
                    builder.addValue(value);
                }
                Attribute withAttribute = builder.toAttribute();
                if (withAttribute != null) {
                    withDone = true;
                    bdfUserPrefsEditor.putAttribute(withAttribute);
                }
            }
            if (!withDone) {
                bdfUserPrefsEditor.removeAttribute(BdfUserSpace.TABLEEXPORT_WITH_KEY);
            }
            if (this.withStatusSheet) {
                Attribute statussheetAttribute = AttributeBuilder.toAttribute(BdfUserSpace.TABLEEXPORT_STATUSSHEET_KEY, "1");
                bdfUserPrefsEditor.putAttribute(statussheetAttribute);
            } else {
                bdfUserPrefsEditor.removeAttribute(BdfUserSpace.TABLEEXPORT_STATUSSHEET_KEY);
            }
        }
        this.setDone("_ done.sphere.redacteurdefaulttableexportparameters", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        Redacteur redacteur = this.requestHandler.getMandatoryRedacteur();
        boolean isSame = BdfUserUtils.isSame(this.bdfUser, redacteur);
        if (!isSame) {
            this.checkSubsetAdmin(redacteur.getSphere());
        }
        this.redacBdfUserPrefs = isSame ? this.bdfUser.getPrefs() : this.bdfServer.createBdfUser(redacteur).getPrefs();
        TableExportParametersBuilder builder = TableExportParametersBuilder.init().setFicheTableParameters(this.requestHandler.getFicheTableParameters()).setHeaderType(this.requestHandler.getHeaderType());
        this.tableExportParameters = builder.toTableExportParameters();
        this.withStatusSheet = this.requestHandler.isTrue(STATUSSHEET_PARAMNAME);
    }
}

