/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.selection;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.SelectionManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.interaction.FicheQueryParser;
import net.fichotheque.corpus.SortConstants;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.SelectionDef;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class UserSelectionChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UserSelectionChange";
    public static final String SORTTYPE_PARAMNAME = "sorttype";
    public static final String SELECTIONTYPE_PARAMNAME = "selectiontype";
    public static final String SELECTIONDEF_TYPE_PARAMVALUE = "selectiondef";
    public static final String SIMPLE_TYPE_PARAMVALUE = "simple";
    private String sortType;
    private SelectionDef selectionDef;
    private FicheQuery ficheQuery;

    public UserSelectionChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        SelectionManager selectionManager = this.bdfServer.getSelectionManager();
        if (this.selectionDef != null) {
            selectionManager.setFicheSelection(this.bdfUser, this.selectionDef.getName(), this.sortType);
        } else {
            selectionManager.setFicheSelection(this.bdfUser, this.ficheQuery, this.sortType);
        }
        this.bdfServer.store(this.bdfUser, "selection", "sort", this.sortType);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String selectionType;
        String sorttypeParamValue = this.requestHandler.getTrimedParameter(SORTTYPE_PARAMNAME);
        if (!sorttypeParamValue.isEmpty()) {
            try {
                this.sortType = SortConstants.checkSortType(sorttypeParamValue);
            }
            catch (IllegalArgumentException iae) {
                throw BdfErrors.unknownParameterValue(SORTTYPE_PARAMNAME, sorttypeParamValue);
            }
        } else {
            this.sortType = "id-asc";
        }
        switch (selectionType = this.requestHandler.getTrimedParameter(SELECTIONTYPE_PARAMNAME)) {
            case "selectiondef": {
                this.selectionDef = this.requestHandler.getMandatorySelectionDef();
                break;
            }
            default: {
                this.ficheQuery = FicheQueryParser.parse(this.requestHandler.getRequestMap(), this.bdfServer, this.bdfUser);
            }
        }
    }
}

