/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.runners.SqlExportRunner;
import java.io.IOException;
import net.fichotheque.exportation.sql.SqlExportDef;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SqlExportRunCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SqlExportRun";
    private SqlExportDef sqlExportDef;

    public SqlExportRunCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() {
        PathConfiguration pathConfiguration = PathConfigurationBuilder.build(this.bdfServer);
        CommandMessage message = null;
        try {
            message = SqlExportRunner.run(this.sqlExportDef, this.bdfServer, pathConfiguration, true);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        this.putResultObject("obj.sqlexportdef", this.sqlExportDef);
        this.putResultObject("obj.pathconfiguration", pathConfiguration);
        this.setCommandMessage(message);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.sqlExportDef = this.requestHandler.getMandatorySqlExportDef();
    }
}

