/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.SqlExportManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.exportation.sql.SqlExportDef;
import net.fichotheque.tools.exportation.sql.SqlExportDefBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SqlExportCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SqlExportCreation";
    public static final String COMMANDKEY = "_ EXP-41";
    public static final String NEWSQLEXPORT_PARAMNAME = "newsqlexport";
    private String newSqlExportName;

    public SqlExportCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        SqlExportManager sqlExportManager = this.bdfServer.getSqlExportManager();
        SqlExportDef sqlExportDef = SqlExportDefBuilder.init(this.newSqlExportName).toSqlExportDef();
        sqlExportManager.putSqlExportDef(sqlExportDef);
        this.putResultObject("obj.sqlexportdef", sqlExportDef);
        this.setDone("_ done.exportation.sqlexportcreation", this.newSqlExportName);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.newSqlExportName = this.getMandatory(NEWSQLEXPORT_PARAMNAME).trim();
        if (this.newSqlExportName.length() == 0) {
            throw BdfErrors.error("_ error.empty.exportname");
        }
        SqlExportManager sqlExportManager = this.bdfServer.getSqlExportManager();
        SqlExportDef sqlExportDef = sqlExportManager.getSqlExportDef(this.newSqlExportName);
        if (sqlExportDef != null) {
            throw BdfErrors.error("_ error.existing.sqlexport", this.newSqlExportName);
        }
        try {
            SqlExportDef.checkSqlExportName(this.newSqlExportName);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.exportname", this.newSqlExportName);
        }
    }
}

