/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.utils.BalayageUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class BalayageContentCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "BalayageContentCreation";
    public static final String COMMANDKEY = "_ EXP-54";
    public static final String SUBDIR_PARAMNAME = "subdir";
    public static final String NEWCONTENT_PARAMNAME = "newcontent";
    private String balayageName;
    private String subdir;
    private String newContentName;

    public BalayageContentCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        BalayageDescription balayageDescription;
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        String contentPath = this.subdir.length() > 0 ? this.subdir + "/" + this.newContentName : this.newContentName;
        try (InputStream is = IOUtils.toInputStream(BalayageUtils.getDefaultContent(this.newContentName, this.subdir), "UTF-8");){
            balayageDescription = this.bdfServer.getBalayageManager().putBalayageContent(this.balayageName, contentPath, is, editOrigin);
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.balayagecontent_io", ioe.getMessage());
        }
        if (balayageDescription != null) {
            this.putResultObject("obj.templatedescription", balayageDescription);
            this.setDone("_ done.exportation.balayagecontentcreation", this.balayageName, contentPath);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        BalayageDescription balayageDescription = this.requestHandler.getMandatoryBalayageDescription();
        this.balayageName = balayageDescription.getName();
        this.subdir = this.getMandatory(SUBDIR_PARAMNAME);
        if (!BalayageContentCreationCommand.isValidSubdir(this.subdir)) {
            throw BdfErrors.unknownParameterValue(SUBDIR_PARAMNAME, this.subdir);
        }
        this.newContentName = this.getMandatory(NEWCONTENT_PARAMNAME).trim();
        if (this.newContentName.isEmpty()) {
            throw BdfErrors.error("_ errror.empty.balayage.contentname");
        }
        if (!BalayageUtils.isValidContentName(this.newContentName, this.subdir)) {
            throw BdfErrors.error("_ error.wrong.balayage.contentname");
        }
    }

    private static boolean isValidSubdir(String subdir) {
        switch (subdir) {
            case "": 
            case "extraction": 
            case "xslt": {
                return true;
            }
        }
        return false;
    }
}

