/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.subsettree.TreeParser;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SubsetTreeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SubsetTree";
    public static final String CORPUS_COMMANDKEY = "_ CNF-13";
    public static final String THESAURUS_COMMANDKEY = "_ CNF-14";
    public static final String SPHERE_COMMANDKEY = "_ CNF-15";
    public static final String ALBUM_COMMANDKEY = "_ CNF-16";
    public static final String ADDENDA_COMMANDKEY = "_ CNF-17";
    public static final String CATEGORY_PARAMNAME = "category";
    public static final String TREE_PARAMNAME = "tree";
    private String treeString;
    private short category;

    public SubsetTreeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        SubsetTree subsetTree = TreeParser.parse(this.bdfServer, this.treeString, this.category);
        try (EditSession session = this.startEditSession("configuration", COMMANDNAME);){
            session.getBdfServerEditor().setSubsetTree(this.category, subsetTree);
        }
        this.setDone("_ done.configuration.subsettree", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String categoryString = this.getMandatory(CATEGORY_PARAMNAME);
        try {
            this.category = SubsetKey.categoryToShort(categoryString);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.unknownParameterValue(CATEGORY_PARAMNAME, categoryString);
        }
        this.treeString = this.getMandatory(TREE_PARAMNAME);
    }
}

