/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.tools.FichothequeTools;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class IllustrationRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "IllustrationRemove";
    public static final String COMMANDKEY = "_ ALB-11";
    private Illustration illustration;

    public IllustrationRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Album album = this.illustration.getAlbum();
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            FichothequeTools.remove(fichothequeEditor, this.illustration);
        }
        this.putResultObject("obj.album", album);
        this.setDone("_ done.album.illustrationremove", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.illustration = this.requestHandler.getMandatoryIllustration();
        this.getPermissionChecker().checkWrite(this.illustration);
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
    }
}

