/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.diagnostic.urlscan.UrlInfo;
import fr.exemole.bdfserver.tools.diagnostic.urlscan.UrlReport;
import fr.exemole.bdfserver.tools.diagnostic.urlscan.UrlReportCache;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.ArrayList;
import net.mapeadores.util.http.UrlStatus;
import net.mapeadores.util.http.UrlTestEngine;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class UrlTestCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UrlTest";
    public static final String URL_PARAMNAME = "url";
    private String[] urlArray;

    public UrlTestCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        ArrayList<UrlReport> urlReportList = new ArrayList<UrlReport>();
        ArrayList<UrlInfo> urlInfoList = new ArrayList<UrlInfo>();
        for (String url : this.urlArray) {
            UrlStatus urlStatus = UrlTestEngine.test(url);
            UrlReport urlReport = new UrlReport(url, urlStatus, System.currentTimeMillis());
            urlReportList.add(urlReport);
            urlInfoList.add(UrlInfo.init(url, urlReport));
        }
        UrlReportCache cache = new UrlReportCache(this.bdfServer);
        cache.cache(urlReportList, true);
        this.putResultObject("obj.urlinfocollection", urlInfoList);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.urlArray = this.requestHandler.getTokens(URL_PARAMNAME);
        if (this.urlArray.length == 0) {
            throw BdfErrors.emptyMandatoryParameter(URL_PARAMNAME);
        }
    }
}

