/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.NoRemoveableSubsetException;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AddendaRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AddendaRemove";
    public static final String COMMANDKEY = "_ ADD-04";
    private Addenda addenda;

    public AddendaRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        SubsetKey addendaKey = this.addenda.getSubsetKey();
        try (EditSession session = this.startEditSession("addenda", COMMANDNAME);){
            try {
                session.getFichothequeEditor().removeAddenda(this.addenda);
            }
            catch (NoRemoveableSubsetException nrse) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.putResultObject("obj.subsetkey", addendaKey);
        this.setDone("_ done.addenda.addendaremove", addendaKey.getSubsetName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.addenda = this.requestHandler.getMandatoryAddenda();
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        if (!this.addenda.isRemoveable()) {
            throw BdfErrors.error("_ error.notremoveable.addenda");
        }
    }
}

