/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.addenda.Addenda;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AddendaAttributeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AddendaAttributeChange";
    public static final String COMMANDKEY = "_ ADD-03";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Addenda addenda;
    private AttributeChange attributeChange;

    public AddendaAttributeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("addenda", COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes(this.addenda.getAddendaMetadata(), this.attributeChange);
        }
        this.putResultObject("obj.addenda", this.addenda);
        this.setDone("_ done.global.attributechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.addenda = this.requestHandler.getMandatoryAddenda();
        this.checkSubsetAdmin(this.addenda);
        String attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
        this.attributeChange = AttributeParser.parse(attributes);
    }
}

