/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.core;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.Banques;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.tools.core.BanqueBuilder;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfext.scarabe.tools.core.LigneBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Liaison;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.PointeurUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;

public class MouvementBuilder {
    private MouvementBuilder() {
    }

    public static Mouvement build(FicheMeta ficheMeta, ScarabeContext scarabeContext, FichothequeQuestioner fichothequeQuestioner) {
        FichePointeur mouvementPointeur = PointeurFactory.newFichePointeur((Corpus)ficheMeta.getCorpus());
        mouvementPointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
        return MouvementBuilder.build(mouvementPointeur, scarabeContext, fichothequeQuestioner, null, null);
    }

    public static Mouvement build(FichePointeur mouvementPointeur, ScarabeContext scarabeContext, FichothequeQuestioner fichothequeQuestioner, Banques banques, Currencies currencies) {
        Junctions banqueJunctions;
        int banqueLength;
        Object numerochequeObj;
        AliasHolder coreAliasHolder = scarabeContext.getCoreAliasHolder();
        InternalMouvement mouvement = new InternalMouvement((FicheMeta)mouvementPointeur.getCurrentSubsetItem());
        ArrayList<Message> errorMessageList = new ArrayList<Message>();
        DateItem mouvementDateItem = PointeurUtils.getDate((FichePointeur)mouvementPointeur, (CorpusField)coreAliasHolder.getCorpusField("mouvement_date"));
        if (mouvementDateItem == null) {
            MouvementBuilder.addError(errorMessageList, "_ error.empty.scarabe.date");
        } else {
            FuzzyDate date = mouvementDateItem.getDate();
            if (date.getType() != 5) {
                MouvementBuilder.addError(errorMessageList, "_ error.wrong.scarabe.datetype");
            } else {
                mouvement.date = date;
                mouvement.annee = date.getYear();
            }
        }
        CorpusField numeropieceField = coreAliasHolder.getCorpusField("mouvement_numeropiece");
        Object numeropieceObj = mouvementPointeur.getValue(numeropieceField);
        if (numeropieceObj == null) {
            MouvementBuilder.addError(errorMessageList, "_ error.empty.scarabe.numeropiece");
        } else {
            int numeropiece = MouvementBuilder.testPositiveInteger(numeropieceObj);
            if (numeropiece < 0) {
                MouvementBuilder.addError(errorMessageList, "_ error.wrong.scarabe.numeropiece");
            } else {
                mouvement.numeropiece = numeropiece;
            }
        }
        CorpusField numerochequeField = coreAliasHolder.getCorpusField("mouvement_numerocheque");
        if (numerochequeField != null && (numerochequeObj = mouvementPointeur.getValue(numerochequeField)) != null) {
            int numerocheque = MouvementBuilder.testPositiveInteger(numerochequeObj);
            if (numerocheque < 0) {
                MouvementBuilder.addError(errorMessageList, "_ error.wrong.scarabe.numerocheque");
            } else {
                mouvement.numerocheque = numerocheque;
            }
        }
        if ((banqueLength = (banqueJunctions = mouvementPointeur.getJunctions((Subset)coreAliasHolder.getThesaurus("banque"))).getEntryList().size()) == 0) {
            MouvementBuilder.addError(errorMessageList, "_ error.empty.scarabe.banque");
        } else if (banqueLength > 1) {
            MouvementBuilder.addError(errorMessageList, "_ error.unsupported.scarabe.toomany_banque");
        } else {
            Motcle banqueMotcle = (Motcle)banqueJunctions.getFirstSubsetItem();
            Banque banque = banques == null ? BanqueBuilder.init(banqueMotcle, coreAliasHolder) : banques.getBanqueByIdalpha(banqueMotcle.getIdalpha());
            if (banque == null) {
                throw new IllegalStateException("banque should not be null");
            }
            if (banque.hasError()) {
                MouvementBuilder.addError(errorMessageList, "_ error.unsupported.scarabe.witherrors_banque");
            }
            mouvement.banque = banque;
        }
        Junctions modepaiementJunctions = mouvementPointeur.getJunctions((Subset)coreAliasHolder.getThesaurus("modepaiement"));
        int modepaiementLength = modepaiementJunctions.getEntryList().size();
        if (modepaiementLength == 0) {
            MouvementBuilder.addError(errorMessageList, "_ error.empty.scarabe.modepaiement");
        } else if (modepaiementLength > 1) {
            MouvementBuilder.addError(errorMessageList, "_ error.unsupported.scarabe.toomany_modepaiement");
        } else {
            mouvement.modepaiement = (Motcle)modepaiementJunctions.getFirstSubsetItem();
        }
        Junctions rapprochementJunctions = mouvementPointeur.getJunctions((Subset)coreAliasHolder.getThesaurus("rapprochement"));
        int rapprochementLength = rapprochementJunctions.getEntryList().size();
        if (rapprochementLength == 0) {
            mouvement.rapprochement = null;
        } else if (rapprochementLength > 1) {
            MouvementBuilder.addError(errorMessageList, "_ error.unsupported.scarabe.toomany_rapprochement");
        } else {
            mouvement.rapprochement = (Motcle)rapprochementJunctions.getFirstSubsetItem();
        }
        AmountItem debit = PointeurUtils.getAmount((FichePointeur)mouvementPointeur, (CorpusField)coreAliasHolder.getCorpusField("mouvement_montantdebit"));
        AmountItem credit = PointeurUtils.getAmount((FichePointeur)mouvementPointeur, (CorpusField)coreAliasHolder.getCorpusField("mouvement_montantcredit"));
        if (debit == null && credit == null) {
            MouvementBuilder.addError(errorMessageList, "_ error.empty.scarabe.montant");
        } else if (debit != null && credit != null) {
            MouvementBuilder.addError(errorMessageList, "_ error.unsupported.scarabe.bothmontant");
        } else {
            boolean isDebit;
            AmountItem montant;
            if (debit != null) {
                montant = debit;
                isDebit = true;
            } else {
                montant = credit;
                isDebit = false;
            }
            ExtendedCurrency currency = montant.getCurrency();
            long lg = montant.toMoneyLong();
            if (lg < 0L) {
                MouvementBuilder.addError(errorMessageList, "_ error.unsupported.scarabe.negativemontant");
            } else {
                ExtendedCurrency banqueCurrency;
                mouvement.montantMoneyLong = lg;
                mouvement.isDebit = isDebit;
                mouvement.montant = montant;
                mouvement.currency = currency;
                if (currencies != null) {
                    int currencyIndex = currencies.indexOf((Object)currency);
                    if (currencyIndex == -1) {
                        MouvementBuilder.addError(errorMessageList, "_ error.unsupported.scarabe.differentcurrency_banque");
                    } else {
                        mouvement.currencyIndex = currencyIndex;
                    }
                }
                if (mouvement.banque != null && (banqueCurrency = mouvement.banque.getCurrency()) != null && !currency.equals((Object)banqueCurrency)) {
                    MouvementBuilder.addError(errorMessageList, "_ error.unsupported.scarabe.differentcurrency_banque");
                }
            }
        }
        FicheItem libelleItem = (FicheItem)mouvementPointeur.getValue(coreAliasHolder.getCorpusField("mouvement_libelle"));
        String libelle = "";
        if (libelleItem != null && libelleItem instanceof Item) {
            libelle = ((Item)libelleItem).getValue();
        }
        if (libelle.equals("")) {
            MouvementBuilder.addError(errorMessageList, "_ error.empty.scarabe.libelle");
        } else {
            mouvement.libelle = libelle;
        }
        FicheItem beneficiaire = (FicheItem)mouvementPointeur.getValue(coreAliasHolder.getCorpusField("mouvement_beneficiaire"));
        mouvement.beneficiaire = beneficiaire;
        if (beneficiaire != null) {
            mouvement.beneficiaireString = CoreUtils.toBeneficiaireString(beneficiaire, fichothequeQuestioner);
        }
        if (!errorMessageList.isEmpty()) {
            mouvement.errorMessageList = errorMessageList;
        }
        MouvementBuilder.initFichesLiees(mouvementPointeur, scarabeContext, mouvement, fichothequeQuestioner);
        return mouvement;
    }

    private static void addError(List<Message> errorMessageList, String key) {
        errorMessageList.add(LocalisationUtils.toMessage((String)key));
    }

    private static int testPositiveInteger(Object obj) {
        if (!(obj instanceof NumberItem)) {
            return -1;
        }
        Decimal decimal = ((NumberItem)obj).getDecimal();
        if (decimal.getPartieDecimale() != 0) {
            return -1;
        }
        int entier = (int)decimal.getPartieEntiere();
        if (entier < 0) {
            return -1;
        }
        return entier;
    }

    private static void initFichesLiees(FichePointeur mouvementPointeur, ScarabeContext scarabeContext, InternalMouvement mouvement, FichothequeQuestioner fichothequeQuestioner) {
        Corpus avanceCorpus;
        Collection avanceLiaisons;
        Corpus apportCorpus;
        Collection apportLiaisons;
        FichePointeur lignePointeur;
        AliasHolder coreAliasHolder = scarabeContext.getCoreAliasHolder();
        boolean withLigneError = false;
        long computeMontantTotal = 0L;
        Corpus depenseCorpus = coreAliasHolder.getCorpus("depense");
        Collection depenseLiaisons = mouvementPointeur.getStandardLiaisons((Subset)depenseCorpus);
        if (!depenseLiaisons.isEmpty()) {
            lignePointeur = PointeurFactory.newFichePointeur((Corpus)depenseCorpus);
            ArrayList<Ligne> depenseList = new ArrayList<Ligne>();
            for (Liaison liaison : depenseLiaisons) {
                lignePointeur.setCurrentSubsetItem(liaison.getSubsetItem());
                Ligne ligne = LigneBuilder.build(lignePointeur, scarabeContext, mouvement, fichothequeQuestioner, "depense");
                if (ligne.hasError()) {
                    withLigneError = true;
                }
                depenseList.add(ligne);
                computeMontantTotal += ligne.getComputeMoneyLong();
            }
            mouvement.depenseList = CoreUtils.toLigneList(depenseList);
        }
        if (!(apportLiaisons = mouvementPointeur.getStandardLiaisons((Subset)(apportCorpus = coreAliasHolder.getCorpus("apport")))).isEmpty()) {
            lignePointeur = PointeurFactory.newFichePointeur((Corpus)apportCorpus);
            ArrayList<Ligne> apportList = new ArrayList<Ligne>();
            for (Liaison liaison : apportLiaisons) {
                lignePointeur.setCurrentSubsetItem(liaison.getSubsetItem());
                Ligne ligne = LigneBuilder.build(lignePointeur, scarabeContext, mouvement, fichothequeQuestioner, "apport");
                if (ligne.hasError()) {
                    withLigneError = true;
                }
                apportList.add(ligne);
                computeMontantTotal += ligne.getComputeMoneyLong();
            }
            mouvement.apportList = CoreUtils.toLigneList(apportList);
        }
        if (!(avanceLiaisons = mouvementPointeur.getStandardLiaisons((Subset)(avanceCorpus = coreAliasHolder.getCorpus("avance")))).isEmpty()) {
            ArrayList<Ligne> avanceList = new ArrayList<Ligne>();
            ArrayList<Ligne> soldeAvanceList = new ArrayList<Ligne>();
            lignePointeur = PointeurFactory.newFichePointeur((Corpus)avanceCorpus);
            for (Liaison liaison : avanceLiaisons) {
                Ligne ligne;
                lignePointeur.setCurrentSubsetItem(liaison.getSubsetItem());
                int currentWeight = liaison.getTie().getWeight();
                boolean soldeAvance = false;
                if (currentWeight == 2) {
                    ligne = LigneBuilder.buildSoldeAvance(lignePointeur, scarabeContext, mouvement, fichothequeQuestioner);
                    soldeAvanceList.add(ligne);
                } else {
                    if (currentWeight != 1) continue;
                    ligne = LigneBuilder.build(lignePointeur, scarabeContext, mouvement, fichothequeQuestioner, "avance");
                }
                if (ligne.hasError()) {
                    withLigneError = true;
                }
                if (currentWeight == 1) {
                    avanceList.add(ligne);
                } else if (currentWeight == 2) {
                    // empty if block
                }
                computeMontantTotal += ligne.getComputeMoneyLong();
            }
            mouvement.avanceList = CoreUtils.toLigneList(avanceList);
            mouvement.soldeAvanceList = CoreUtils.toLigneList(soldeAvanceList);
        }
        mouvement.withLigneError = withLigneError;
        mouvement.checkLigneComputeMontantTotal(computeMontantTotal);
    }

    private static class InternalMouvement
    implements Mouvement {
        private final FicheMeta ficheMeta;
        private FuzzyDate date;
        private int annee;
        private int numeropiece = -1;
        private int numerocheque = -1;
        private long montantMoneyLong;
        private AmountItem montant;
        private Banque banque;
        private Motcle modepaiement;
        private Motcle rapprochement;
        private boolean isDebit;
        private String libelle = "";
        private FicheItem beneficiaire;
        private String beneficiaireString = "";
        private List<Message> errorMessageList;
        private List<Ligne> depenseList = CoreUtils.EMPTY_LIGNELIST;
        private List<Ligne> avanceList = CoreUtils.EMPTY_LIGNELIST;
        private List<Ligne> soldeAvanceList = CoreUtils.EMPTY_LIGNELIST;
        private List<Ligne> apportList = CoreUtils.EMPTY_LIGNELIST;
        private long resteMoneyLong;
        private boolean withLigneError = false;
        private ExtendedCurrency currency = null;
        private int currencyIndex = -1;

        private InternalMouvement(FicheMeta ficheMeta) {
            this.ficheMeta = ficheMeta;
        }

        @Override
        public int getId() {
            return this.ficheMeta.getId();
        }

        @Override
        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        @Override
        public FuzzyDate getDate() {
            return this.date;
        }

        @Override
        public int getAnnee() {
            return this.annee;
        }

        @Override
        public int getNumeropiece() {
            return this.numeropiece;
        }

        @Override
        public Banque getBanque() {
            return this.banque;
        }

        @Override
        public Motcle getModepaiement() {
            return this.modepaiement;
        }

        @Override
        public int getNumerocheque() {
            return this.numerocheque;
        }

        @Override
        public Motcle getRapprochement() {
            return this.rapprochement;
        }

        @Override
        public boolean isDebit() {
            return this.isDebit;
        }

        @Override
        public long getMontantMoneyLong() {
            return this.montantMoneyLong;
        }

        @Override
        public long getResteMoneyLong() {
            return this.resteMoneyLong;
        }

        @Override
        public ExtendedCurrency getCurrency() {
            return this.currency;
        }

        @Override
        public int getCurrencyIndex() {
            return this.currencyIndex;
        }

        @Override
        public AmountItem getMontant() {
            return this.montant;
        }

        @Override
        public String getLibelle() {
            return this.libelle;
        }

        @Override
        public FicheItem getBeneficiaire() {
            return this.beneficiaire;
        }

        @Override
        public String getBeneficiaireString() {
            return this.beneficiaireString;
        }

        @Override
        public boolean hasError() {
            return this.errorMessageList != null;
        }

        @Override
        public List<Message> getErrorMessageList() {
            if (this.errorMessageList != null) {
                return this.errorMessageList;
            }
            return LocalisationUtils.EMPTY_MESSAGELIST;
        }

        @Override
        public List<Ligne> getDepenseList() {
            return this.depenseList;
        }

        @Override
        public List<Ligne> getApportList() {
            return this.apportList;
        }

        @Override
        public List<Ligne> getAvanceList() {
            return this.avanceList;
        }

        @Override
        public List<Ligne> getSoldeAvanceList() {
            return this.soldeAvanceList;
        }

        @Override
        public boolean withLigneError() {
            return this.withLigneError;
        }

        private void checkLigneComputeMontantTotal(long computeMontantTotal) {
            this.resteMoneyLong = this.isDebit ? this.montantMoneyLong + computeMontantTotal : this.montantMoneyLong - computeMontantTotal;
        }
    }
}

