/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.core;

import fr.exemole.bdfext.scarabe.api.core.AvanceInfo;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Liaison;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.PointeurUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.primitives.FuzzyDate;

public class AvanceInfoBuilder {
    private final boolean avanceSoldee;
    private final List<DepenseInfoBuilder> depenseInfoBuilderList = new ArrayList<DepenseInfoBuilder>();
    private FuzzyDate avanceDate = null;
    private FuzzyDate soldeAvanceDate = null;
    private boolean withError = false;

    public AvanceInfoBuilder(boolean avanceSoldee) {
        this.avanceSoldee = avanceSoldee;
    }

    public void setAvanceDate(FuzzyDate avanceDate) {
        this.avanceDate = avanceDate;
    }

    public void setSoldeAvanceDate(FuzzyDate soldeAvanceDate) {
        this.soldeAvanceDate = soldeAvanceDate;
    }

    public AvanceInfo toAvanceInfo() {
        List<AvanceInfo.DepenseInfo> finalDepenseInfoList;
        if (this.depenseInfoBuilderList.isEmpty()) {
            finalDepenseInfoList = CoreUtils.EMPTY_DEPENSEINFOLIST;
        } else {
            int size = this.depenseInfoBuilderList.size();
            AvanceInfo.DepenseInfo[] depenseInfoArray = new AvanceInfo.DepenseInfo[size];
            for (int i = 0; i < size; ++i) {
                depenseInfoArray[i] = this.depenseInfoBuilderList.get(i).toDepenseInfo();
            }
            finalDepenseInfoList = CoreUtils.wrap(depenseInfoArray);
        }
        return new InternalAvanceInfo(this.avanceSoldee, this.avanceDate, this.soldeAvanceDate, this.withError, finalDepenseInfoList);
    }

    public static AvanceInfo build(FichePointeur lignePointeur, AliasHolder coreAliasHolder, FicheMeta ficheMouvementDeCreation, FicheMeta ficheMouvementDeSolde) {
        DateItem dateItem;
        Corpus corpusDepense = coreAliasHolder.getCorpus("depense");
        Corpus mouvementCorpus = coreAliasHolder.getCorpus("mouvement");
        boolean avanceSoldee = ficheMouvementDeSolde != null;
        AvanceInfoBuilder avanceInfoBuilder = new AvanceInfoBuilder(avanceSoldee);
        CorpusField mouvementDateField = coreAliasHolder.getCorpusField("mouvement_date");
        FichePointeur mouvementPointeur = PointeurFactory.newFichePointeur((Corpus)mouvementCorpus);
        if (ficheMouvementDeCreation != null) {
            mouvementPointeur.setCurrentSubsetItem((SubsetItem)ficheMouvementDeCreation);
            dateItem = PointeurUtils.getDate((FichePointeur)mouvementPointeur, (CorpusField)mouvementDateField);
            if (dateItem != null) {
                avanceInfoBuilder.setAvanceDate(dateItem.getDate());
            }
        }
        if (ficheMouvementDeSolde != null) {
            mouvementPointeur.setCurrentSubsetItem((SubsetItem)ficheMouvementDeSolde);
            dateItem = PointeurUtils.getDate((FichePointeur)mouvementPointeur, (CorpusField)mouvementDateField);
            if (dateItem != null) {
                avanceInfoBuilder.setSoldeAvanceDate(dateItem.getDate());
            }
        }
        FichePointeur depensePointeur = PointeurFactory.newFichePointeur((Corpus)corpusDepense);
        CorpusField montantField = CoreUtils.getMontant(coreAliasHolder, "depense");
        CorpusField dateprevueField = CoreUtils.getDateprevue(coreAliasHolder, "depense");
        Junctions ficheJunctions = lignePointeur.getJunctions((Subset)corpusDepense);
        if (!ficheJunctions.isEmpty()) {
            for (Junctions.Entry entry : ficheJunctions.getEntryList()) {
                FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
                DepenseInfoBuilder depenseInfoBuilder = new DepenseInfoBuilder(ficheMeta);
                depensePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
                AmountItem montant = PointeurUtils.getAmount((FichePointeur)depensePointeur, (CorpusField)montantField);
                if (montant == null) {
                    depenseInfoBuilder.addError("_ error.empty.scarabe.montant");
                } else {
                    long val = montant.toMoneyLong();
                    depenseInfoBuilder.setAmount(val, montant.getCurrency());
                }
                if (depensePointeur.getValue(dateprevueField) != null) {
                    depenseInfoBuilder.addError("_ error.unsupported.scarabe.notempty_dateprevue");
                }
                Collection mouvementLiaisons = depensePointeur.getStandardLiaisons((Subset)mouvementCorpus);
                if (avanceSoldee) {
                    boolean here = false;
                    for (Liaison liaison : mouvementLiaisons) {
                        if (liaison.getTie().getWeight() != 1) continue;
                        here = true;
                        if (liaison.getSubsetItem().getId() == ficheMouvementDeSolde.getId()) continue;
                        depenseInfoBuilder.addError("_ error.unsupported.scarabe.differentsoldeavance");
                    }
                    if (!here) {
                        depenseInfoBuilder.addError("_ error.empty.scarabe.soldeavance");
                    }
                } else {
                    for (Liaison liaison : mouvementLiaisons) {
                        if (liaison.getTie().getWeight() != 1) continue;
                        depenseInfoBuilder.addError("_ error.unsupported.scarabe.notempty_mouvement_avance");
                    }
                }
                avanceInfoBuilder.depenseInfoBuilderList.add(depenseInfoBuilder);
            }
        }
        return avanceInfoBuilder.toAvanceInfo();
    }

    private static class DepenseInfoBuilder {
        private final FicheMeta ficheMeta;
        private long moneyLong;
        private ExtendedCurrency currency;
        private List<Message> errorMessageList = null;

        private DepenseInfoBuilder(FicheMeta ficheMeta) {
            this.ficheMeta = ficheMeta;
        }

        private void addError(String errorMessageKey) {
            if (this.errorMessageList == null) {
                this.errorMessageList = new ArrayList<Message>();
            }
            this.errorMessageList.add(LocalisationUtils.toMessage((String)errorMessageKey));
        }

        private void setAmount(long moneyLong, ExtendedCurrency currency) {
            this.moneyLong = moneyLong;
            this.currency = currency;
        }

        private AvanceInfo.DepenseInfo toDepenseInfo() {
            List finalErrorMessageList = this.errorMessageList != null ? LocalisationUtils.wrap((Message[])this.errorMessageList.toArray(new Message[this.errorMessageList.size()])) : LocalisationUtils.EMPTY_MESSAGELIST;
            return new InternalDepenseInfo(this.ficheMeta, this.moneyLong, this.currency, finalErrorMessageList);
        }
    }

    private static class InternalAvanceInfo
    implements AvanceInfo {
        private final boolean avanceSoldee;
        private final FuzzyDate avanceDate;
        private final FuzzyDate soldeAvanceDate;
        private final boolean withError;
        private final List<AvanceInfo.DepenseInfo> depenseInfoList;

        private InternalAvanceInfo(boolean avanceSoldee, FuzzyDate avanceDate, FuzzyDate soldeAvanceDate, boolean withError, List<AvanceInfo.DepenseInfo> depenseInfoList) {
            this.avanceSoldee = avanceSoldee;
            this.avanceDate = avanceDate;
            this.soldeAvanceDate = soldeAvanceDate;
            this.withError = withError;
            this.depenseInfoList = depenseInfoList;
        }

        @Override
        public boolean isAvanceSoldee() {
            return this.avanceSoldee;
        }

        @Override
        public boolean hasError() {
            return this.withError;
        }

        @Override
        public List<AvanceInfo.DepenseInfo> getDepenseInfoList() {
            return this.depenseInfoList;
        }

        @Override
        public FuzzyDate getAvanceDate() {
            return this.avanceDate;
        }

        @Override
        public FuzzyDate getSoldeAvanceDate() {
            return this.soldeAvanceDate;
        }
    }

    private static class InternalDepenseInfo
    implements AvanceInfo.DepenseInfo {
        private final FicheMeta ficheMeta;
        private final long moneyLong;
        private final ExtendedCurrency currency;
        private final List<Message> errorMessageList;

        private InternalDepenseInfo(FicheMeta ficheMeta, long moneyLong, ExtendedCurrency currency, List<Message> errorMessageList) {
            this.ficheMeta = ficheMeta;
            this.moneyLong = moneyLong;
            this.currency = currency;
            this.errorMessageList = errorMessageList;
        }

        @Override
        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        @Override
        public List<Message> getErrorMessageList() {
            return this.errorMessageList;
        }

        @Override
        public long getMoneyLong() {
            return this.moneyLong;
        }

        @Override
        public ExtendedCurrency getCurrency() {
            return this.currency;
        }

        @Override
        public boolean hasError() {
            return this.errorMessageList.isEmpty();
        }
    }
}

