/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html.ficheform;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormEntry;
import fr.exemole.bdfserver.api.ficheform.FormEntryProvider;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.FormEntryProviderFactory;
import fr.exemole.bdfserver.tools.ficheform.builders.CorpusEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.AmountPropEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.FieldEntryFactory;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.syntax.FormSyntax;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyLong;
import net.mapeadores.util.primitives.FuzzyDate;

public class LigneFormEntryProvider
implements FormEntryProvider {
    private final Fichotheque fichotheque;
    private final FichothequeQuestioner fichothequeQuestioner;
    private final FicheFormParameters ficheFormParameters;
    private final Mouvement mouvement;
    private final SubsetKey mouvementSubsetKey;
    private final ScarabeContext scarabeContext;
    private final String corpusAlias;
    private final FormEntryProvider defaultProvider;

    public LigneFormEntryProvider(FicheFormParameters ficheFormParameters, Mouvement mouvement, String corpusAlias, ScarabeContext scarabeContext) {
        this.fichotheque = ficheFormParameters.getBdfServer().getFichotheque();
        this.fichothequeQuestioner = ficheFormParameters.getFichothequeQuestioner();
        this.scarabeContext = scarabeContext;
        this.mouvement = mouvement;
        this.mouvementSubsetKey = scarabeContext.getCoreAliasHolder().getCorpus("mouvement").getSubsetKey();
        this.ficheFormParameters = ficheFormParameters;
        this.corpusAlias = corpusAlias;
        this.defaultProvider = FormEntryProviderFactory.newInstance((FicheFormParameters)ficheFormParameters);
    }

    public FormEntry.Include getFormEntry(FichePointeur fichePointeur, IncludeUi includeUi) {
        ExtendedIncludeKey includeKey;
        SubsetKey subsetKey;
        if (includeUi instanceof SubsetIncludeUi && (subsetKey = (includeKey = ((SubsetIncludeUi)includeUi).getExtendedIncludeKey()).getSubsetKey()).equals((Object)this.mouvementSubsetKey) && (!includeKey.hasWeightFilter() || includeKey.getWeightFilter() == 1)) {
            return CorpusEntryBuilder.init((String)includeUi.getName(), (Corpus)this.mouvement.getFicheMeta().getCorpus()).setHasWeightFilter(includeKey.hasWeightFilter()).populateOptions(this.ficheFormParameters, includeUi).addFicheMeta(this.mouvement.getFicheMeta(), 1).toCorpusEntry();
        }
        return this.defaultProvider.getFormEntry(fichePointeur, includeUi);
    }

    public FormEntry.Field getFormEntry(FichePointeur fichePointeur, FieldUi fieldUI) {
        FormEntry.Field formEntry = this.testLibelle(fichePointeur, fieldUI);
        if (formEntry != null) {
            return formEntry;
        }
        formEntry = this.testDate(fichePointeur, fieldUI);
        if (formEntry != null) {
            return formEntry;
        }
        formEntry = this.testMontant(fichePointeur, fieldUI);
        if (formEntry != null) {
            return formEntry;
        }
        formEntry = this.testBeneficiaire(fichePointeur, fieldUI);
        if (formEntry != null) {
            return formEntry;
        }
        return this.defaultProvider.getFormEntry(fichePointeur, fieldUI);
    }

    private FormEntry.Field testDate(FichePointeur fichePointeur, FieldUi fieldUI) {
        CorpusField dateField = CoreUtils.getDate(this.scarabeContext.getCoreAliasHolder(), this.corpusAlias);
        if (!fieldUI.getFieldKey().equals((Object)dateField.getFieldKey())) {
            return null;
        }
        String defaultValue = null;
        FuzzyDate date = this.mouvement.getDate();
        if (date != null) {
            defaultValue = date.toString();
        }
        return FieldEntryFactory.newSimpleFieldInstance((FichePointeur)fichePointeur, (FicheFormParameters)this.ficheFormParameters, (CorpusField)dateField, (FieldUi)fieldUI, (String)defaultValue);
    }

    private FormEntry.Field testMontant(FichePointeur fichePointeur, FieldUi fieldUi) {
        CorpusField montantField = CoreUtils.getMontant(this.scarabeContext.getCoreAliasHolder(), this.corpusAlias);
        if (!this.areMatching(fieldUi, montantField)) {
            return null;
        }
        AmountItem montant = this.mouvement.getMontant();
        if (montant != null) {
            ExtendedCurrency currency = montant.getCurrency();
            int fractionDigits = currency.getDefaultFractionDigits();
            montant = new AmountItem(MoneyLong.toDecimal((long)this.mouvement.getResteMoneyLong(), (int)fractionDigits, (boolean)true), currency);
            montant = this.checkAmount(montant);
        }
        if (CorpusMetadataUtils.isCurrenciesProp((CorpusField)montantField)) {
            return AmountPropEntryBuilder.build((FicheFormParameters)this.ficheFormParameters, (CorpusField)montantField, (FieldUi)fieldUi, (FicheItem)montant).toAmountPropEntry();
        }
        String defaultValue = null;
        if (montant != null) {
            FormSyntax.Parameters parameters = FicheFormUtils.getParameters((FicheFormParameters)this.ficheFormParameters, (CorpusField)montantField);
            defaultValue = FormSyntax.toString((FicheItem)montant, (FichothequeQuestioner)this.fichothequeQuestioner, (FormSyntax.Parameters)parameters);
        }
        return FieldEntryFactory.newSimpleFieldInstance((FichePointeur)fichePointeur, (FicheFormParameters)this.ficheFormParameters, (CorpusField)montantField, (FieldUi)fieldUi, defaultValue);
    }

    private FormEntry.Field testLibelle(FichePointeur fichePointeur, FieldUi fieldUi) {
        CorpusField libelleField = CoreUtils.getLibelle(this.scarabeContext.getCoreAliasHolder(), this.corpusAlias);
        if (!this.areMatching(fieldUi, libelleField)) {
            return null;
        }
        String defaultValue = this.mouvement.getLibelle();
        return FieldEntryFactory.newSimpleFieldInstance((FichePointeur)fichePointeur, (FicheFormParameters)this.ficheFormParameters, (CorpusField)libelleField, (FieldUi)fieldUi, (String)defaultValue);
    }

    private FormEntry.Field testBeneficiaire(FichePointeur fichePointeur, FieldUi fieldUi) {
        CorpusField beneficiaireField = CoreUtils.getBeneficiaire(this.scarabeContext.getCoreAliasHolder(), this.corpusAlias);
        if (beneficiaireField == null) {
            return null;
        }
        if (!this.areMatching(fieldUi, beneficiaireField)) {
            return null;
        }
        String defaultValue = null;
        FicheItem ficheItem = this.mouvement.getBeneficiaire();
        if (ficheItem != null) {
            FormSyntax.Parameters parameters = FicheFormUtils.getParameters((FicheFormParameters)this.ficheFormParameters, (CorpusField)beneficiaireField);
            defaultValue = FormSyntax.toString((FicheItem)ficheItem, (FichothequeQuestioner)this.fichothequeQuestioner, (FormSyntax.Parameters)parameters);
        }
        return FieldEntryFactory.newSimpleFieldInstance((FichePointeur)fichePointeur, (FicheFormParameters)this.ficheFormParameters, (CorpusField)beneficiaireField, (FieldUi)fieldUi, defaultValue);
    }

    private AmountItem checkAmount(AmountItem amountItem) {
        if (amountItem == null) {
            return null;
        }
        if (this.mouvement.isDebit() ? this.corpusAlias.equals("apport") : this.corpusAlias.equals("depense") || this.corpusAlias.equals("avance")) {
            return this.getOpposite(amountItem);
        }
        return amountItem;
    }

    private AmountItem getOpposite(AmountItem amountItem) {
        return new AmountItem(amountItem.getDecimal().getOpposite(), amountItem.getCurrency());
    }

    private boolean areMatching(FieldUi fieldUi, CorpusField corpusField) {
        return fieldUi.getFieldKey().equals((Object)corpusField.getFieldKey());
    }
}

