/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate.tools.conversion.zip;

import fr.exemole.bdfext.resourcesupdate.api.conversion.Conversion;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.Label;

public final class IniConversionZipEngine {
    private IniConversionZipEngine() {
    }

    public static void zip(Conversion conversion, ZipOutputStream zipOutputStream, String rootPath) throws IOException {
        String conversionName = conversion.getName();
        int thesaurusInfoCount = conversion.getThesaurusInfoCount();
        for (int i = 0; i < thesaurusInfoCount; ++i) {
            Conversion.ThesaurusInfo thesaurusInfo = conversion.getThesaurusInfo(i);
            String alias = thesaurusInfo.getAlias();
            if (alias == null) {
                alias = thesaurusInfo.getThesaurus().getSubsetName();
            }
            ThesaurusBuffer thesaurusBuffer = IniConversionZipEngine.toThesaurusBuffer(thesaurusInfo);
            int length = thesaurusBuffer.langs.size();
            for (int j = 0; j < length; ++j) {
                Lang lang = (Lang)thesaurusBuffer.langs.get(j);
                String content = thesaurusBuffer.bufArray[j].toString();
                if (content.length() <= 0) continue;
                ZipEntry zipEntry = new ZipEntry(rootPath + conversionName + "/" + lang.toString() + "/" + alias + ".ini");
                zipOutputStream.putNextEntry(zipEntry);
                IOUtils.write((String)content, (OutputStream)zipOutputStream, (String)"UTF-8");
            }
        }
    }

    private static ThesaurusBuffer toThesaurusBuffer(Conversion.ThesaurusInfo thesaurusInfo) {
        Thesaurus thesaurus = thesaurusInfo.getThesaurus();
        Langs langs = thesaurusInfo.getLangs();
        int length = langs.size();
        StringBuilder[] bufArray = new StringBuilder[length];
        for (int i = 0; i < length; ++i) {
            bufArray[i] = new StringBuilder();
        }
        ThesaurusBuffer thesaurusBuffer = new ThesaurusBuffer(langs, bufArray);
        Motcle motcle = thesaurus.getFirst();
        if (motcle != null) {
            IniConversionZipEngine.bufMotcle(thesaurusBuffer, motcle, thesaurusInfo.isWithUnderscorePrefix());
        }
        return thesaurusBuffer;
    }

    private static void bufMotcle(ThesaurusBuffer thesaurusBuffer, Motcle motcle, boolean withUnderscorePrefix) {
        int length = thesaurusBuffer.langs.size();
        String idalpha = motcle.getIdalpha();
        for (int i = 0; i < length; ++i) {
            Lang lang = (Lang)thesaurusBuffer.langs.get(i);
            Label label = motcle.getLabels().getLabel(lang);
            if (label == null) continue;
            StringBuilder buf = thesaurusBuffer.bufArray[i];
            if (withUnderscorePrefix && !idalpha.startsWith("_ ")) {
                buf.append("_ ");
            }
            buf.append(idalpha);
            buf.append(" = ");
            IniConversionZipEngine.appendValue(buf, label.getLabelString());
            buf.append('\n');
        }
        Motcle next = motcle.getNext();
        if (next != null) {
            IniConversionZipEngine.bufMotcle(thesaurusBuffer, next, withUnderscorePrefix);
        }
    }

    private static void appendValue(StringBuilder buf, String value) {
        int length = value.length();
        block9: for (int i = 0; i < length; ++i) {
            char carac = value.charAt(i);
            switch (carac) {
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\u00a0': {
                    buf.append("\\u00A0");
                    continue block9;
                }
                case '\u202f': {
                    buf.append("\\u202F");
                    continue block9;
                }
                case '_': {
                    if (i == 0 || i == length - 1) {
                        buf.append("\\u0020");
                        continue block9;
                    }
                    buf.append('_');
                    continue block9;
                }
                default: {
                    buf.append(carac);
                }
            }
        }
    }

    private static class ThesaurusBuffer {
        private final Langs langs;
        private final StringBuilder[] bufArray;

        private ThesaurusBuffer(Langs langs, StringBuilder[] bufArray) {
            this.langs = langs;
            this.bufArray = bufArray;
        }
    }
}

