/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce;

import fr.exemole.bdfext.icyce.Icyce;
import fr.exemole.bdfext.icyce.IcyceConstants;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;

public final class IcyceUtils
implements IcyceConstants {
    public static final SubsetKey CONF_THESAURUSKEY = SubsetKey.build((short)2, (String)"conferences");
    public static final FieldKey PAYS_FIELDKEY = FieldKey.build((short)1, (String)"pays");
    public static final SubsetKey PARLANGUE_THESAURUSKEY = SubsetKey.build((short)2, (String)"groupelinguistique");

    private IcyceUtils() {
    }

    public static short getAction(String action) {
        if (action.equals("sphere")) {
            return 2;
        }
        if (action.equals("index")) {
            return 1;
        }
        if (action.equals("liste")) {
            return 4;
        }
        if (action.equals("conf")) {
            return 5;
        }
        if (action.equals("parlangue")) {
            return 6;
        }
        if (action.equals("mesconfs")) {
            return 7;
        }
        if (action.equals("confirmationbouton")) {
            return 8;
        }
        if (action.equals("confirmationenvoi")) {
            return 9;
        }
        throw new IllegalArgumentException();
    }

    public static Motcle getConfirmMotcle(Fichotheque fichotheque) {
        Thesaurus confirmThesaurus = fichotheque.getThesaurus("confirmationdelegation");
        return confirmThesaurus.getMotcleByIdalpha("B");
    }

    public static Corpus getConfCorpus(Fichotheque fichotheque) {
        return IcyceUtils.getCorpus(fichotheque, "confnationale");
    }

    public static Thesaurus getConfThesaurus(Fichotheque fichotheque) {
        return (Thesaurus)fichotheque.getSubset(CONF_THESAURUSKEY);
    }

    public static Thesaurus getParLangueThesaurus(Fichotheque fichotheque) {
        return (Thesaurus)fichotheque.getSubset(PARLANGUE_THESAURUSKEY);
    }

    public static List<Corpus> getCorpusList(Fichotheque fichotheque, String name) {
        ArrayList<Corpus> corpusList = new ArrayList<Corpus>();
        List<SubsetKey> subsetKeyList = Icyce.config.getSubsetKeyList(name);
        if (subsetKeyList != null) {
            for (SubsetKey subsetKey : subsetKeyList) {
                Corpus corpus = (Corpus)fichotheque.getSubset(subsetKey);
                if (corpus == null) continue;
                corpusList.add(corpus);
            }
        }
        return corpusList;
    }

    public static Corpus getCorpus(Fichotheque fichotheque, String name) {
        try {
            SubsetKey corpusKey = SubsetKey.parse((short)1, (String)name);
            return (Corpus)fichotheque.getSubset(corpusKey);
        }
        catch (ParseException pe) {
            throw new IllegalStateException(pe);
        }
    }
}

