/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.json.producers;

import java.io.IOException;
import net.desmodo.atlas.json.api.Warning;
import net.desmodo.atlas.json.api.WarningList;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;

public abstract class AbstractJsonProducer
implements JsonProducer {
    private WarningList warningList;

    protected AbstractJsonProducer() {
    }

    public WarningList getWarningList() {
        return this.warningList;
    }

    public void setWarningList(WarningList warningList) {
        this.warningList = warningList;
    }

    public void writeWarnings(JSONWriter jsonWriter) throws IOException {
        if (this.warningList == null) {
            return;
        }
        int warningCount = this.warningList.getWarningCount();
        if (warningCount == 0) {
            return;
        }
        jsonWriter.key("warnings");
        jsonWriter.array();
        for (int i = 0; i < warningCount; ++i) {
            Warning warning = this.warningList.getWarning(i);
            jsonWriter.object();
            jsonWriter.key("key");
            jsonWriter.value((Object)warning.getWarningKey());
            jsonWriter.key("parameter");
            jsonWriter.value((Object)warning.getWarningParameter());
            String value = warning.getWarningValue();
            if (value != null) {
                jsonWriter.key("value");
                jsonWriter.value((Object)value);
            }
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }
}

