/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.impl;

import java.util.HashMap;
import java.util.Map;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.impl.StructureImpl;
import net.desmodo.atlas.impl.TermCoder;
import net.desmodo.atlas.impl.TermImpl;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.ExistingIdctxtException;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleEditor;
import net.desmodo.atlas.structure.InvalidIdctxtException;
import net.desmodo.atlas.structure.RecursiveException;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.desmodo.atlas.structure.UnremovableContexteException;

class GrilleImpl
extends TermImpl
implements Grille {
    private final Map<String, Contexte> contexteMap = new HashMap<String, Contexte>();
    private final String nomgrille;
    private final InternalContexteList firstLevelContexteList = new InternalContexteList();
    private final TermCoder termCoder;
    private final short grilleType;
    private final Map<String, InfoTrash> trashContexteMap = new HashMap<String, InfoTrash>();
    private final StructureImpl structure;
    private final GrilleEditorImpl grilleEditor = new GrilleEditorImpl();

    GrilleImpl(StructureImpl defaultStructure, String nomgrille, int codegrille, TermCoder termCoder) {
        super(codegrille);
        this.termCoder = termCoder;
        this.nomgrille = nomgrille;
        this.structure = defaultStructure;
        this.grilleType = nomgrille.length() == 0 ? (short)7 : (short)2;
    }

    @Override
    public Contexte getContexteByIdctxt(String idctxt) {
        return this.contexteMap.get(idctxt);
    }

    @Override
    public ContexteList getFirstLevelContexteList() {
        return this.firstLevelContexteList;
    }

    @Override
    public String getGrilleName() {
        return this.nomgrille;
    }

    @Override
    public Atlas getAtlas() {
        return this.structure.getAtlas();
    }

    @Override
    public short getTermType() {
        return this.grilleType;
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    GrilleEditorImpl getGrilleEditor() {
        return this.grilleEditor;
    }

    private ContexteImpl testContexte(Contexte contexte, String argument) throws IllegalArgumentException {
        if (StructureUtils.isSpecialContexte(contexte)) {
            throw new IllegalArgumentException(argument + " argument is a special Contexte (ContexteHorsGrille, ContexteSansFamille");
        }
        try {
            ContexteImpl defcontexte = (ContexteImpl)contexte;
            if (defcontexte.getGrille() != this) {
                throw new IllegalArgumentException(argument + " argument does not come from this grille");
            }
            if (defcontexte.getChildIndex() == -1) {
                throw new IllegalArgumentException(argument + " argument does not exist anymore");
            }
            return defcontexte;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(argument + " argument does not come from this grille");
        }
    }

    private class ContexteImpl
    extends TermImpl
    implements Contexte {
        private final String idctxt;
        private ContexteImpl parent;
        private InternalContexteList children;
        private boolean active;
        private final short contexteType;
        private int childIndex;

        private ContexteImpl(int codeContexte, String idctxt) {
            super(codeContexte);
            this.active = true;
            this.childIndex = -1;
            this.idctxt = idctxt;
            this.contexteType = GrilleImpl.this.grilleType == 7 ? (short)4 : (short)3;
        }

        @Override
        public ContexteList getChildren() {
            if (this.children == null) {
                return StructureUtils.EMPTY_CONTEXTE_LIST;
            }
            return this.children;
        }

        @Override
        public int getChildIndex() {
            return this.childIndex;
        }

        private void setChildIndex(int childIndex) {
            this.childIndex = childIndex;
            if (childIndex < 0) {
                throw new IllegalStateException("valeur n\u00e9gative interdite");
            }
            if (this.parent == null) {
                if (GrilleImpl.this.firstLevelContexteList.contextes[childIndex] != this) {
                    throw new IllegalStateException("l'index doit \u00eatre modifi\u00e9 apr\u00e8s tout changement de liste");
                }
            } else if (this.parent.children.contextes[childIndex] != this) {
                throw new IllegalStateException("index incorrect");
            }
        }

        private boolean hasChildren() {
            return this.children != null && this.children.getContexteCount() > 0;
        }

        private void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public Grille getGrille() {
            return GrilleImpl.this;
        }

        @Override
        public String getIdctxt() {
            return this.idctxt;
        }

        @Override
        public Contexte getParent() {
            return this.parent;
        }

        @Override
        public Atlas getAtlas() {
            return GrilleImpl.this.getAtlas();
        }

        @Override
        public short getTermType() {
            return this.contexteType;
        }

        private boolean hasAsDescendant(Contexte contexte) {
            if (this.children == null) {
                return false;
            }
            Contexte ctxtParent = contexte.getParent();
            if (ctxtParent == null) {
                return false;
            }
            if (ctxtParent.equals(this)) {
                return true;
            }
            this.hasAsDescendant(ctxtParent);
            return false;
        }

        private InternalContexteList getContexteList() {
            if (this.children == null) {
                this.children = new InternalContexteList();
            }
            return this.children;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }
    }

    private static class InternalContexteList
    implements ContexteList {
        private ContexteImpl[] contextes = new ContexteImpl[8];
        private int size = 0;

        private InternalContexteList() {
        }

        private void removeContexte(ContexteImpl defcont) {
            int index = defcont.getChildIndex();
            if (index < 0 || index >= this.size) {
                throw new IllegalArgumentException("bad parent =" + defcont.getIdctxt());
            }
            if (!this.contextes[index].equals(defcont)) {
                throw new IllegalArgumentException("error index");
            }
            for (int i = index; i < this.size - 1; ++i) {
                ContexteImpl c;
                this.contextes[i] = c = this.contextes[i + 1];
                c.setChildIndex(i);
            }
            --this.size;
            this.contextes[this.size] = null;
        }

        private void addContexte(ContexteImpl defcont) {
            if (this.contextes.length == this.size) {
                ContexteImpl[] nv = new ContexteImpl[this.size * 2];
                System.arraycopy(this.contextes, 0, nv, 0, this.size);
                this.contextes = nv;
            }
            this.contextes[this.size] = defcont;
            defcont.setChildIndex(this.size);
            ++this.size;
        }

        private void translateContexte(int oldindex, int newindex) {
            if (newindex < 0 || newindex >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            ContexteImpl value = this.contextes[oldindex];
            if (oldindex < newindex) {
                for (int i = oldindex; i < newindex; ++i) {
                    ContexteImpl c;
                    this.contextes[i] = c = this.contextes[i + 1];
                    c.setChildIndex(i);
                }
            } else {
                for (int i = oldindex; i > newindex; --i) {
                    ContexteImpl c;
                    this.contextes[i] = c = this.contextes[i - 1];
                    c.setChildIndex(i);
                }
            }
            this.contextes[newindex] = value;
            value.setChildIndex(newindex);
        }

        @Override
        public Contexte getContexte(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.contextes[index];
        }

        @Override
        public int getContexteCount() {
            return this.size;
        }
    }

    private class GrilleEditorImpl
    implements GrilleEditor {
        private GrilleEditorImpl() {
        }

        @Override
        public Grille getGrille() {
            return GrilleImpl.this;
        }

        @Override
        public Contexte createContexte(String idctxt) throws ExistingIdctxtException, InvalidIdctxtException {
            if (idctxt == null) {
                int availableValue = 1;
                while (true) {
                    idctxt = String.valueOf(availableValue);
                    if (GrilleImpl.this.contexteMap.containsKey(idctxt)) {
                        ++availableValue;
                        continue;
                    }
                    break;
                }
            } else {
                int check = StructureUtils.checkValidity(idctxt);
                if (check < 0) {
                    throw new InvalidIdctxtException(check);
                }
                if (GrilleImpl.this.contexteMap.containsKey(idctxt)) {
                    throw new ExistingIdctxtException(idctxt);
                }
            }
            int newCode = GrilleImpl.this.termCoder.getNewCode();
            ContexteImpl defcont = new ContexteImpl(newCode, idctxt);
            GrilleImpl.this.contexteMap.put(idctxt, defcont);
            GrilleImpl.this.firstLevelContexteList.addContexte(defcont);
            GrilleImpl.this.termCoder.setTerm(newCode, defcont);
            GrilleImpl.this.structure.fireContexteCreated(defcont);
            return defcont;
        }

        @Override
        public void removeContexte(Contexte contexte) throws UnremovableContexteException {
            ContexteImpl defcont = GrilleImpl.this.testContexte(contexte, "contexte");
            if (defcont.hasChildren()) {
                throw new UnremovableContexteException();
            }
            this.unbindContexte(defcont);
            GrilleImpl.this.structure.fireContexteRemoved(defcont);
        }

        private void unbindContexte(ContexteImpl defaultContexte) {
            GrilleImpl.this.termCoder.setTerm(defaultContexte.getCode(), null);
            if (defaultContexte.parent != null) {
                defaultContexte.parent.getContexteList().removeContexte(defaultContexte);
            } else {
                GrilleImpl.this.firstLevelContexteList.removeContexte(defaultContexte);
            }
            defaultContexte.parent = null;
            defaultContexte.childIndex = -1;
            GrilleImpl.this.contexteMap.remove(defaultContexte.getIdctxt());
        }

        @Override
        public Contexte restoreContexte(String idctxt) throws ExistingIdctxtException {
            throw new UnsupportedOperationException("Need to be implemented");
        }

        @Override
        public void setActive(Contexte contexte, boolean active) {
            ContexteImpl defcont = GrilleImpl.this.testContexte(contexte, "contexte");
            boolean oldactive = defcont.isActive();
            if (oldactive != active) {
                defcont.setActive(active);
                GrilleImpl.this.structure.fireActiveChanged(defcont, oldactive);
            }
        }

        @Override
        public void setChildIndex(Contexte contexte, int index) throws IndexOutOfBoundsException {
            ContexteImpl defcont = GrilleImpl.this.testContexte(contexte, "contexte");
            int oldindex = defcont.getChildIndex();
            if (oldindex == index) {
                return;
            }
            InternalContexteList contexteList = defcont.parent != null ? defcont.parent.getContexteList() : GrilleImpl.this.firstLevelContexteList;
            contexteList.translateContexte(oldindex, index);
            GrilleImpl.this.structure.fireChildIndexChanged(defcont, oldindex);
        }

        @Override
        public void setParent(Contexte contexte, Contexte contexteParent) throws RecursiveException {
            ContexteImpl defcont = GrilleImpl.this.testContexte(contexte, "contexte");
            ContexteImpl newParent = null;
            if (contexteParent != null) {
                newParent = GrilleImpl.this.testContexte(contexteParent, "contexteParent");
            }
            ContexteImpl oldParent = defcont.parent;
            if (newParent == null) {
                if (oldParent == null) {
                    return;
                }
                defcont.parent = newParent;
                oldParent.getContexteList().removeContexte(defcont);
                GrilleImpl.this.firstLevelContexteList.addContexte(defcont);
            } else {
                if (defcont.hasAsDescendant(newParent)) {
                    throw new RecursiveException();
                }
                if (oldParent == null) {
                    defcont.parent = newParent;
                    GrilleImpl.this.firstLevelContexteList.removeContexte(defcont);
                    newParent.getContexteList().addContexte(defcont);
                } else {
                    if (oldParent.equals(newParent)) {
                        return;
                    }
                    defcont.parent = newParent;
                    oldParent.getContexteList().removeContexte(defcont);
                    newParent.getContexteList().addContexte(defcont);
                }
            }
            GrilleImpl.this.structure.fireParentChanged(defcont, oldParent);
        }

        @Override
        public AtlasEditor getAtlasEditor() {
            return GrilleImpl.this.structure.getAtlasEditor();
        }
    }

    class InfoTrash {
        ContexteImpl contexte;
        int indexInParent;
        String idctxtParent;

        InfoTrash(ContexteImpl contexte, int indexInParent, String idctxtParent) {
            this.contexte = contexte;
            this.indexInParent = indexInParent;
            this.idctxtParent = idctxtParent;
        }
    }
}

