/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.producers.html;

import fr.exemole.bdfext.desmoservice.Desmoservice;
import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.CommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusHtmlUtils;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;

public class DescripteurHtmlProducer
extends BdfServerHtmlProducer {
    private final DesmoserviceContext desmoserviceContext;
    private final Thesaurus thesaurus;
    private final Motcle motcle;
    private final boolean withFontAwesome;

    public DescripteurHtmlProducer(BdfParameters bdfParameters, DesmoserviceContext desmoserviceContext, Motcle motcle) {
        super(bdfParameters);
        this.desmoserviceContext = desmoserviceContext;
        this.thesaurus = motcle.getThesaurus();
        this.motcle = motcle;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.APPELANT);
        this.addThemeCss(new String[]{"thesaurus.css"});
        this.withFontAwesome = this.checkFontAwesome();
    }

    public void printHtml() {
        Lang thesaurusLang = BdfServerUtils.checkLangDisponibility((BdfServer)this.bdfServer, (Thesaurus)this.thesaurus, (Lang)this.workingLang);
        Thesaurus familleThesaurus = this.desmoserviceContext.getCoreAliasHolder().getThesaurus("famille");
        String familleIdalpha = "";
        Motcle familleMotcle = this.getFamilleMotcle(familleThesaurus);
        if (familleMotcle != null) {
            familleIdalpha = familleMotcle.getIdalpha();
        }
        this.start();
        ThesaurusHtmlUtils.printMotcleToolBar((HtmlPrinter)this, (BdfServer)this.bdfServer, (BdfUser)this.bdfUser, (Motcle)this.motcle, (String)BdfInstructionUtils.getAbsolutePageName((String)Desmoservice.DOMAIN, (String)"Descripteur"), (Lang)thesaurusLang, (boolean)this.withFontAwesome);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action(Desmoservice.DOMAIN).family("DSM").name("FamilleChange").lockey("_ DSM-02").page("Descripteur").__(CommandBoxUtils.insert((Object)this.motcle)).submitLocKey("_ submit.fr-exemole-desmoservice.famillechange");
        this.__start(commandBox).INPUT_text(this.name("famille").value(familleIdalpha).size("20").populate((Consumer)Appelant.motcle().wanted_code_id().limit(1).subsets(new SubsetKey[]{familleThesaurus.getSubsetKey()}))).__end((Object)commandBox);
        this.end();
    }

    private Motcle getFamilleMotcle(Thesaurus familleThesaurus) {
        Junctions junctions = this.fichotheque.getJunctions((SubsetItem)this.motcle, (Subset)familleThesaurus);
        for (Junctions.Entry entry : junctions.getEntryList()) {
            Junction junction = entry.getJunction();
            if (!BdfAtlasUtils.isFamilleJunction(junction)) continue;
            return (Motcle)entry.getSubsetItem();
        }
        return null;
    }
}

