/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.commands;

import fr.exemole.bdfext.desmoservice.Desmoservice;
import fr.exemole.bdfext.desmoservice.DesmoserviceBdfExtensionInitializer;
import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.EditableResourceStorage;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.ExistingFieldKeyException;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadataEditor;
import net.fichotheque.tools.alias.AliasDOMReader;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;

public class InstallationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Installation";
    private final DesmoserviceContext desmoserviceContext;
    private AliasDOMReader aliasDOMReader;
    private Langs langs;
    private MessageLocalisation[] messageLocalisationArray;

    public InstallationCommand(BdfServer bdfServer, RequestMap requestMap, DesmoserviceContext desmoserviceContext) {
        super(bdfServer, requestMap);
        this.desmoserviceContext = desmoserviceContext;
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession(Desmoservice.DOMAIN, COMMANDNAME);){
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            try {
                this.createAtlas(fichothequeEditor);
                this.createGrille(fichothequeEditor);
                this.createFamille(fichothequeEditor);
                this.createDescripteur(fichothequeEditor);
                this.createLienhierarchique(fichothequeEditor);
            }
            catch (ExistingSubsetException existingSubsetException) {
                // empty catch block
            }
            this.saveVersion(fichothequeEditor.getEditOrigin());
            this.desmoserviceContext.reinit();
        }
        this.setDone("_ done.fr-exemole-desmoservice.installation", new Object[0]);
    }

    protected void checkParameters() throws ErrorMessageException {
        this.aliasDOMReader = this.readCoreAlias();
        this.langs = this.bdfServer.getLangConfiguration().getWorkingLangs();
        int length = this.langs.size();
        this.messageLocalisationArray = new MessageLocalisation[length];
        for (int i = 0; i < length; ++i) {
            this.messageLocalisationArray[i] = this.bdfServer.getL10nManager().getMessageLocalisation((Lang)this.langs.get(i));
        }
    }

    private void createAtlas(FichothequeEditor fichothequeEditor) throws ExistingSubsetException {
        CorpusField corpusField2;
        ThesaurusEditor atlasThesaurusEditor = fichothequeEditor.createThesaurus(this.aliasDOMReader.getThesaurusKey("atlas"), "idalpha");
        ThesaurusMetadataEditor thesaurusMetadataEditor = atlasThesaurusEditor.getThesaurusMetadataEditor();
        thesaurusMetadataEditor.setAuthorizedLangs(this.langs);
        CorpusEditor atlasCorpusEditor = fichothequeEditor.createCorpus(this.aliasDOMReader.getCorpusKey("atlas"), (Subset)atlasThesaurusEditor.getThesaurus());
        this.setIntitule(thesaurusMetadataEditor, "_ alias.fr-exemole-desmoservice.atlas.intitule_thesaurus");
        CorpusMetadataEditor corpusMetadataEditor = atlasCorpusEditor.getCorpusMetadataEditor();
        this.setIntitule(corpusMetadataEditor, "_ alias.fr-exemole-desmoservice.atlas.intitule_corpus", "_ alias.fr-exemole-desmoservice.atlas.intitule_existingfiche", "_ alias.fr-exemole-desmoservice.atlas.intitule_newfiche");
        try {
            corpusField2 = corpusMetadataEditor.createCorpusField(this.aliasDOMReader.getFieldKey("atlas_langs"), "language");
            this.setLibelle(corpusMetadataEditor, corpusField2, "_ alias.fr-exemole-desmoservice.atlas.info_langs");
        }
        catch (ExistingFieldKeyException corpusField2) {
            // empty catch block
        }
        try {
            corpusField2 = corpusMetadataEditor.createCorpusField(this.aliasDOMReader.getFieldKey("atlas_params"), "item");
            this.setLibelle(corpusMetadataEditor, corpusField2, "_ alias.fr-exemole-desmoservice.atlas.info_params");
            corpusMetadataEditor.setFieldOption(corpusField2, "infoDisplay", (Object)"block");
        }
        catch (ExistingFieldKeyException corpusField3) {
        }
        catch (FieldOptionException foe) {
            throw new ShouldNotOccurException((Exception)((Object)foe));
        }
    }

    private void createGrille(FichothequeEditor fichothequeEditor) throws ExistingSubsetException {
        ThesaurusEditor grilleThesaurusEditor = fichothequeEditor.createThesaurus(this.aliasDOMReader.getThesaurusKey("grille"), "idalpha");
        ThesaurusMetadataEditor thesaurusMetadataEditor = grilleThesaurusEditor.getThesaurusMetadataEditor();
        thesaurusMetadataEditor.setAuthorizedLangs(this.langs);
        this.setIntitule(thesaurusMetadataEditor, "_ alias.fr-exemole-desmoservice.grille.intitule_thesaurus");
    }

    private void createFamille(FichothequeEditor fichothequeEditor) throws ExistingSubsetException {
        ThesaurusEditor familleThesaurusEditor = fichothequeEditor.createThesaurus(this.aliasDOMReader.getThesaurusKey("famille"), "idalpha");
        ThesaurusMetadataEditor thesaurusMetadataEditor = familleThesaurusEditor.getThesaurusMetadataEditor();
        thesaurusMetadataEditor.setAuthorizedLangs(this.langs);
        this.setIntitule(thesaurusMetadataEditor, "_ alias.fr-exemole-desmoservice.famille.intitule_thesaurus");
    }

    private void createDescripteur(FichothequeEditor fichothequeEditor) throws ExistingSubsetException {
        ThesaurusEditor descripteurThesaurusEditor = fichothequeEditor.createThesaurus(this.aliasDOMReader.getThesaurusKey("descripteur"), "idalpha");
        ThesaurusMetadataEditor thesaurusMetadataEditor = descripteurThesaurusEditor.getThesaurusMetadataEditor();
        thesaurusMetadataEditor.setAuthorizedLangs(this.langs);
        this.setIntitule(thesaurusMetadataEditor, "_ alias.fr-exemole-desmoservice.descripteur.intitule_thesaurus");
    }

    private void createLienhierarchique(FichothequeEditor fichothequeEditor) throws ExistingSubsetException {
        CorpusEditor lienhierarchiqueCorpusEditor = fichothequeEditor.createCorpus(this.aliasDOMReader.getCorpusKey("lienhierarchique"), null);
        CorpusMetadataEditor corpusMetadataEditor = lienhierarchiqueCorpusEditor.getCorpusMetadataEditor();
        this.setIntitule(corpusMetadataEditor, "_ alias.fr-exemole-desmoservice.lienhierarchique.intitule_corpus", "_ alias.fr-exemole-desmoservice.lienhierarchique.intitule_existingfiche", "_ alias.fr-exemole-desmoservice.lienhierarchique.intitule_newfiche");
    }

    private void saveVersion(EditOrigin editOrign) {
        EditableResourceStorage dataStorage = this.desmoserviceContext.getDataStorage();
        RelativePath path = RelativePath.build((String)"conf/version.ini");
        String text = "version = 1";
        try {
            byte[] byteArray = text.getBytes("UTF-8");
            dataStorage.saveResource(path, (InputStream)new ByteArrayInputStream(byteArray), editOrign);
        }
        catch (IOException ioe) {
            throw new BdfStorageException((Throwable)ioe);
        }
    }

    private void setIntitule(ThesaurusMetadataEditor thesaurusMetadataEditor, String messageKey) {
        int length = this.langs.size();
        for (int i = 0; i < length; ++i) {
            CleanedString cs = CleanedString.newInstance((CharSequence)this.messageLocalisationArray[i].toString(messageKey));
            Label label = LabelUtils.toLabel((Lang)((Lang)this.langs.get(i)), (CleanedString)cs);
            thesaurusMetadataEditor.putTitle(label);
        }
    }

    private void setIntitule(CorpusMetadataEditor corpusMetadataEditor, String corpusMessageKey, String ficheExistingMessageKey, String ficheNewMessageKey) {
        int length = this.langs.size();
        for (int i = 0; i < length; ++i) {
            Lang lang = (Lang)this.langs.get(i);
            CleanedString corpusCs = CleanedString.newInstance((CharSequence)this.messageLocalisationArray[i].toString(corpusMessageKey));
            CleanedString ficheExistingCs = CleanedString.newInstance((CharSequence)this.messageLocalisationArray[i].toString(ficheExistingMessageKey));
            CleanedString ficheNewCs = CleanedString.newInstance((CharSequence)this.messageLocalisationArray[i].toString(ficheNewMessageKey));
            corpusMetadataEditor.putTitle(LabelUtils.toLabel((Lang)lang, (CleanedString)corpusCs));
            corpusMetadataEditor.putLabel("fiche", LabelUtils.toLabel((Lang)lang, (CleanedString)ficheExistingCs));
            corpusMetadataEditor.putLabel("newfiche", LabelUtils.toLabel((Lang)lang, (CleanedString)ficheNewCs));
        }
    }

    private void setLibelle(CorpusMetadataEditor corpusMetadataEditor, CorpusField corpusField, String messageKey) {
        int length = this.langs.size();
        for (int i = 0; i < length; ++i) {
            CleanedString cs = CleanedString.newInstance((CharSequence)this.messageLocalisationArray[i].toString(messageKey));
            Label label = LabelUtils.toLabel((Lang)((Lang)this.langs.get(i)), (CleanedString)cs);
            corpusMetadataEditor.putFieldLabel(corpusField, label);
        }
    }

    private AliasDOMReader readCoreAlias() {
        AliasDOMReader aliasDOMReader;
        block8: {
            InputStream is = DesmoserviceBdfExtensionInitializer.class.getResourceAsStream("tools/defaultfiles/desmoservice-alias-core.xml");
            try {
                Document document = DOMUtils.readDocument((InputStream)is);
                AliasDOMReader reader = new AliasDOMReader(null);
                reader.readAlias(document.getDocumentElement());
                aliasDOMReader = reader;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
            is.close();
        }
        return aliasDOMReader;
    }
}

