/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.desmodo.atlas.structure.Contexte;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.Labels;

public class BdfDescripteur
implements Descripteur {
    private final BdfAtlas bdfAtlas;
    private final int code;
    private final Motcle motcle;
    private boolean familleInit = false;
    private Contexte famille = null;

    BdfDescripteur(BdfAtlas bdfAtlas, Motcle motcle, int code) {
        this.bdfAtlas = bdfAtlas;
        this.code = code;
        this.motcle = motcle;
    }

    @Override
    public Iddesc getIddesc() {
        String idalpha = this.motcle.getIdalpha();
        int length = this.bdfAtlas.atlasPrefix.length();
        if (idalpha.length() <= length) {
            throw new IllegalStateException("Idalpha (" + idalpha + ") doit commencer par " + this.bdfAtlas.atlasPrefix);
        }
        return Iddesc.parse(idalpha.substring(length));
    }

    @Override
    public Descripteurs getDescripteurs() {
        return this.bdfAtlas.getDescripteurs();
    }

    @Override
    public synchronized Contexte getFamille() {
        if (!this.familleInit) {
            Junctions familles = this.bdfAtlas.fichotheque.getJunctions((SubsetItem)this.motcle, (Subset)this.bdfAtlas.familleThesaurus);
            boolean done = false;
            for (Junctions.Entry entry : familles.getEntryList()) {
                Junction junction = entry.getJunction();
                if (!BdfAtlasUtils.isFamilleJunction(junction)) continue;
                this.setFamille(this.bdfAtlas.getBdfContexte((Motcle)entry.getSubsetItem()));
                done = true;
                break;
            }
            if (!done) {
                this.setFamille(this.bdfAtlas.getStructure().getSpecialContexte((short)6));
            }
        }
        return this.famille;
    }

    @Override
    public Atlas getAtlas() {
        return this.bdfAtlas;
    }

    @Override
    public short getTermType() {
        return 1;
    }

    @Override
    public Attributes getAttributes() {
        return this.motcle.getAttributes();
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Labels getLabels() {
        return this.motcle.getLabels();
    }

    Motcle getMotcle() {
        return this.motcle;
    }

    void setFamille(Contexte famille) {
        this.familleInit = true;
        this.famille = famille;
    }
}

