/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.json.api;

import fr.exemole.bdfext.desmography.DesmodojsSpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.atlas.RelationReference;
import fr.exemole.bdfext.desmography.json.Extract;
import fr.exemole.bdfext.desmography.json.TermJson;
import fr.exemole.bdfext.desmography.producers.json.AbstractJsonProducer;
import java.io.IOException;
import java.util.List;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;

public class IndexJsonProducer
extends AbstractJsonProducer {
    private final Atlas atlas;
    private final Lang lang;

    public IndexJsonProducer(Atlas atlas, Lang lang) {
        this.atlas = atlas;
        this.lang = lang;
    }

    public void writeJson(Appendable appendable) throws IOException {
        Extract extract = new Extract();
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("index");
        jw.array();
        List<RelationReference> relationReferenceList = AtlasUtils.getRelationReferenceList(this.atlas, this.atlas.getTermThesaurus().getMetadata().getAttributes().getAttribute(DesmodojsSpace.INDEXRELATIONS_KEY));
        if (relationReferenceList.isEmpty()) {
            this.write(jw, RelationReference.build("rootsectors", this.atlas), extract);
        } else {
            for (RelationReference relationReference : relationReferenceList) {
                this.write(jw, relationReference, extract);
            }
        }
        jw.endArray();
        TermJson.properties(jw, this.atlas, extract, this.lang, false);
        jw.endObject();
    }

    private void write(JSONWriter jw, RelationReference relationReference, Extract extract) throws IOException {
        List<FicheMeta> relationList = relationReference.getRelationList();
        if (relationList.isEmpty()) {
            jw.object();
            jw.key("members");
            jw.array();
            if (relationReference.getName().equals("all")) {
                for (Motcle motcle : this.atlas.getTermThesaurus().getFirstLevelList()) {
                    jw.value((Object)extract.addTerm(motcle));
                }
            }
            jw.endArray();
            jw.endObject();
        } else {
            for (FicheMeta relation : relationList) {
                jw.object();
                jw.key("members");
                jw.array();
                List<Motcle> inferiors = AtlasUtils.inferiors(this.atlas, relation);
                for (Motcle motcle : inferiors) {
                    jw.value((Object)extract.addTerm(motcle));
                }
                jw.endArray();
                jw.endObject();
            }
        }
    }
}

