/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.dsmd.dom;

import fr.exemole.bdfext.desmography.atlas.RelationEditor;
import fr.exemole.bdfext.desmography.dsmd.dom.MotcleMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class LiensDOMReader {
    private LiensDOMReader() {
    }

    public static void createLien(Element liensElement, MotcleMatcher motcleMatcher, RelationEditor relationEditor) {
        DOMUtils.readChildren((Element)liensElement, (Consumer)new LiensConsumer(motcleMatcher, relationEditor));
    }

    private static Motcle getContexteFromCtxtElement(Element element, MotcleMatcher motcleMatcher) {
        String idctxt;
        boolean done = true;
        String grilleName = element.getAttribute("grille");
        if (grilleName.length() == 0) {
            grilleName = element.getAttribute("grl");
        }
        if (grilleName.length() == 0) {
            done = false;
        }
        if ((idctxt = element.getAttribute("idctxt")).length() == 0) {
            done = false;
        }
        if (!done) {
            return null;
        }
        return motcleMatcher.matchContexte(grilleName, idctxt, false);
    }

    private static Motcle getDescripteurFromDescElement(Element element, MotcleMatcher motcleMatcher) {
        String iddescString = element.getAttribute("iddesc");
        if (iddescString.length() == 0) {
            return null;
        }
        return motcleMatcher.matchDescripteur(iddescString, false);
    }

    private static class LiensConsumer
    implements Consumer<Element> {
        private final MotcleMatcher motcleMatcher;
        private final RelationEditor relationEditor;

        private LiensConsumer(MotcleMatcher motcleMatcher, RelationEditor relationEditor) {
            this.motcleMatcher = motcleMatcher;
            this.relationEditor = relationEditor;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lhg")) {
                CommonLienConsumer lienConsumer = new CommonLienConsumer(this.motcleMatcher, this.relationEditor, true);
                DOMUtils.readChildren((Element)element, (Consumer)lienConsumer);
                lienConsumer.endInit();
            } else if (tagName.equals("lsm")) {
                CommonLienConsumer lienConsumer = new CommonLienConsumer(this.motcleMatcher, this.relationEditor, false);
                DOMUtils.readChildren((Element)element, (Consumer)lienConsumer);
                lienConsumer.endInit();
            }
        }
    }

    private static class DescCtxt {
        private final Motcle descripteur;
        private final Motcle contexte;

        DescCtxt(Motcle descripteur, Motcle contexte) {
            this.descripteur = descripteur;
            this.contexte = contexte;
        }

        public Motcle getDescripteur() {
            return this.descripteur;
        }

        public Motcle getContexte() {
            return this.contexte;
        }
    }

    private static class DescCtxtConsumer
    implements Consumer<Element> {
        private final MotcleMatcher motcleMatcher;
        private Motcle descripteur;
        private Motcle contexte;

        private DescCtxtConsumer(MotcleMatcher motcleMatcher) {
            this.motcleMatcher = motcleMatcher;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("desc")) {
                if (this.descripteur != null) {
                    return;
                }
                this.descripteur = LiensDOMReader.getDescripteurFromDescElement(element, this.motcleMatcher);
            } else if (tagName.equals("ctxt")) {
                if (this.contexte != null) {
                    return;
                }
                this.contexte = LiensDOMReader.getContexteFromCtxtElement(element, this.motcleMatcher);
            }
        }

        private DescCtxt toDescCtxt() {
            if (this.descripteur == null) {
                return null;
            }
            return new DescCtxt(this.descripteur, this.contexte);
        }
    }

    private static class CommonLienConsumer
    implements Consumer<Element> {
        private final MotcleMatcher motcleMatcher;
        private final RelationEditor relationEditor;
        private final List<DescCtxt> descCtxtList = new ArrayList<DescCtxt>();
        private final List<Motcle> filsList = new ArrayList<Motcle>();
        private final boolean isLhg;

        private CommonLienConsumer(MotcleMatcher motcleMatcher, RelationEditor relationEditor, boolean isLhg) {
            this.motcleMatcher = motcleMatcher;
            this.relationEditor = relationEditor;
            this.isLhg = isLhg;
        }

        @Override
        public void accept(Element element) {
            Motcle descripteur;
            String tagName = element.getTagName();
            if (tagName.equals("desc-ctxt")) {
                DescCtxtConsumer descCtxtConsumer = new DescCtxtConsumer(this.motcleMatcher);
                DOMUtils.readChildren((Element)element, (Consumer)descCtxtConsumer);
                DescCtxt descCtxt = descCtxtConsumer.toDescCtxt();
                if (descCtxt != null) {
                    this.descCtxtList.add(descCtxt);
                }
            } else if (tagName.equals("desc") && this.isLhg && (descripteur = LiensDOMReader.getDescripteurFromDescElement(element, this.motcleMatcher)) != null) {
                this.filsList.add(descripteur);
            }
        }

        private void endInit() {
            if (this.isLhg) {
                this.endLhgInit();
            } else {
                this.endLsmInit();
            }
        }

        private void endLhgInit() {
            int descsSize = this.descCtxtList.size();
            int filsSize = this.filsList.size();
            if (descsSize == 0) {
                return;
            }
            if (filsSize == 0) {
                return;
            }
            for (int i = 0; i < descsSize; ++i) {
                DescCtxt descCtxt = this.descCtxtList.get(i);
                Motcle desc = descCtxt.getDescripteur();
                Set<Motcle> superiors = Collections.singleton(desc);
                Motcle ctxt = descCtxt.getContexte();
                Collection<Object> sectors = ctxt != null ? Collections.singleton(ctxt) : Collections.emptyList();
                this.relationEditor.createHierarchy(superiors, this.filsList, sectors);
            }
        }

        private void endLsmInit() {
        }
    }
}

