/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.secteurs.secteurangulaire;

import net.desmodo.atlas.display.secteurs.secteurangulaire.FaisceauAngleInfo;
import net.desmodo.atlas.display.secteurs.secteurangulaire.Homothetie;
import net.desmodo.atlas.ventilation.Secteur;

public class Chapeau {
    private int startIndex;
    private int endIndex = -1;
    private Secteur secteur;
    private double cartesianAngle;
    private int graphicAngle;

    public Chapeau(Secteur secteur, int startIndex) {
        if (secteur == null) {
            throw new IllegalArgumentException("secteur is null");
        }
        this.secteur = secteur;
        this.startIndex = startIndex;
    }

    public Secteur getSecteur() {
        return this.secteur;
    }

    public double getCartesianAngle() {
        return this.cartesianAngle;
    }

    public int getGraphicAngle() {
        return this.graphicAngle;
    }

    public boolean isInitialized() {
        return this.endIndex != -1;
    }

    public void initialize() {
        this.endIndex = this.startIndex;
    }

    public void initAngle(FaisceauAngleInfo angleInfo, Homothetie homothetie) {
        int interval = this.endIndex - this.startIndex + 1;
        this.graphicAngle = angleInfo.getGraphicStartAngle() + this.startIndex * angleInfo.getGraphicSecteurAngle() + (1 + interval) * angleInfo.getGraphicSecteurAngle() / 2;
        this.cartesianAngle = (interval & 1) == 1 ? homothetie.getCartesianAngle(angleInfo, this.startIndex + interval / 2, 0.5f) : homothetie.getCartesianAngle(angleInfo, this.startIndex + interval / 2, 0.0f);
    }

    public void increment() {
        ++this.endIndex;
    }
}

