/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BadDelimiterException;
import com.Ostermiller.util.BadQuoteException;
import com.Ostermiller.util.CSVParse;
import com.Ostermiller.util.ExcelCSVLexer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

public class ExcelCSVParser
implements CSVParse {
    private InputStream inStream;
    private Reader inReader;
    private ExcelCSVLexer lexer;
    private String tokenCache;
    private int lineCache;
    private int lastLine = -1;

    public ExcelCSVParser(InputStream in, char delimiter) throws BadDelimiterException {
        this.inStream = in;
        this.lexer = new ExcelCSVLexer(in);
        this.changeDelimiter(delimiter);
    }

    public ExcelCSVParser(InputStream in) {
        this.inStream = in;
        this.lexer = new ExcelCSVLexer(in);
    }

    public ExcelCSVParser(Reader in, char delimiter) throws BadDelimiterException {
        this.inReader = in;
        this.lexer = new ExcelCSVLexer(in);
        this.changeDelimiter(delimiter);
    }

    public ExcelCSVParser(Reader in) {
        this.inReader = in;
        this.lexer = new ExcelCSVLexer(in);
    }

    @Override
    public void close() throws IOException {
        if (this.inStream != null) {
            this.inStream.close();
        }
        if (this.inReader != null) {
            this.inReader.close();
        }
    }

    @Override
    public String nextValue() throws IOException {
        if (this.tokenCache == null) {
            this.tokenCache = this.lexer.getNextToken();
            this.lineCache = this.lexer.getLineNumber();
        }
        this.lastLine = this.lineCache;
        String result = this.tokenCache;
        this.tokenCache = null;
        return result;
    }

    @Override
    public int lastLineNumber() {
        return this.lastLine;
    }

    @Override
    public String[] getLine() throws IOException {
        int lineNumber = -1;
        Vector<String> v = new Vector<String>();
        if (this.tokenCache != null) {
            v.add(this.tokenCache);
            lineNumber = this.lineCache;
        }
        while ((this.tokenCache = this.lexer.getNextToken()) != null && (lineNumber == -1 || this.lexer.getLineNumber() == lineNumber)) {
            v.add(this.tokenCache);
            lineNumber = this.lexer.getLineNumber();
        }
        if (v.size() == 0) {
            return null;
        }
        this.lastLine = lineNumber;
        this.lineCache = this.lexer.getLineNumber();
        String[] result = new String[v.size()];
        return v.toArray(result);
    }

    @Override
    public String[][] getAllValues() throws IOException {
        String[] line;
        Vector<String[]> v = new Vector<String[]>();
        while ((line = this.getLine()) != null) {
            v.add(line);
        }
        if (v.size() == 0) {
            return null;
        }
        String[][] result = new String[v.size()][];
        return (String[][])v.toArray((T[])result);
    }

    @Override
    public void changeDelimiter(char newDelim) throws BadDelimiterException {
        this.lexer.changeDelimiter(newDelim);
    }

    @Override
    public void changeQuote(char newQuote) throws BadQuoteException {
        this.lexer.changeQuote(newQuote);
    }

    public void setCommentStart(String commentDelims) {
        this.lexer.setCommentStart(commentDelims);
    }

    @Override
    public int getLastLineNumber() {
        return this.lastLine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void main(String[] args) {
        try {
            String[] t;
            InputStream in;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (!f.exists()) throw new IOException("Could not find " + args[0]);
                if (!f.canRead()) throw new IOException("Could not open " + args[0]);
                in = new FileInputStream(f);
            } else {
                in = System.in;
            }
            ExcelCSVParser p = new ExcelCSVParser(in);
            while ((t = p.getLine()) != null) {
                for (int i = 0; i < t.length; ++i) {
                    System.out.print('\"' + t[i] + '\"');
                    if (i >= t.length - 1) continue;
                    System.out.print(", ");
                }
                System.out.println();
            }
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static String[][] parse(String s) {
        try {
            return new ExcelCSVParser(new StringReader(s)).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }

    public static String[][] parse(String s, char delimiter) throws BadDelimiterException {
        try {
            return new ExcelCSVParser(new StringReader(s), delimiter).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }

    public static String[][] parse(Reader in) throws IOException {
        return new ExcelCSVParser(in).getAllValues();
    }

    public static String[][] parse(Reader in, char delimiter) throws IOException, BadDelimiterException {
        return new ExcelCSVParser(in, delimiter).getAllValues();
    }
}

