/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.ceraicompta;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.exportation.sql.BdfServerSqlExport;
import fr.exemole.bdfserver.api.managers.PasswordManager;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.exportation.table.SqlTableWriter;
import net.fichotheque.tools.exportation.table.TableExportEngine;
import net.mapeadores.util.sql.InsertWriter;
import net.mapeadores.util.table.TableWriter;

public class CeraiComptaSqlExport
implements BdfServerSqlExport {
    public static String[] tables = new String[]{"utilisateur", "projet", "utilisateur_projet", "activite", "groupe_budgetaire", "bailleur", "financement", "subvention", "virement", "avance_sur_frais", "depense"};
    private static SubsetKey projetThesaurusKey;
    private static SubsetKey projetCorpusKey;
    private final Map<String, SubsetTable> subsetTableMap = new HashMap<String, SubsetTable>();
    private final Map<Integer, RedacteurBundle> redacteurMap = new LinkedHashMap<Integer, RedacteurBundle>();
    private final Map<String, Motcle> motcleMap = new HashMap<String, Motcle>();
    private BdfServer bdfServer;
    private Fichotheque fichotheque;
    private TableExport tableExport;
    private ExtractionContext extractionContext;
    private TableExportContext tableExportContext;
    private CellConverter cellConverter;
    private Predicate<SubsetItem> predicate;

    public void setParameter(String name, String value) {
    }

    public void setTableExport(TableExport tableExport, TableExportContext tableExportContext) {
        this.fichotheque = tableExportContext.getFichotheque();
        this.tableExportContext = tableExportContext;
        for (SubsetTable subsetTable : tableExport.getSubsetTableList()) {
            String tableName = subsetTable.getParameterValue("table_name");
            this.subsetTableMap.put(tableName, subsetTable);
        }
    }

    public void setBdfServer(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
    }

    public void setPredicate(Predicate<SubsetItem> predicate) {
        this.predicate = predicate;
    }

    public void setExtractionContext(ExtractionContext extractionContext) {
        this.extractionContext = extractionContext;
    }

    public void setCellConverter(CellConverter cellEngine) {
        this.cellConverter = cellEngine;
    }

    public void exportDump(OutputStream outputStream) throws IOException {
        this.initRedacteurs();
        BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        ExportProcess exportProcess = new ExportProcess(bufWriter);
        exportProcess.run();
        bufWriter.flush();
    }

    void initRedacteurs() {
        PasswordManager passwordManager = this.bdfServer.getPasswordManager();
        Thesaurus projetThesaurus = (Thesaurus)this.fichotheque.getSubset(projetThesaurusKey);
        Corpus projetCorpus = (Corpus)this.fichotheque.getSubset(projetCorpusKey);
        for (FicheMeta ficheMeta : projetCorpus.getFicheMetaList()) {
            Motcle motcle = projetThesaurus.getMotcleById(ficheMeta.getId());
            String projet = this.checkIdalpha(motcle);
            this.motcleMap.put(projet, motcle);
        }
        int id = 1;
        for (Sphere sphere : this.fichotheque.getSphereList()) {
            int[] projetArray;
            SubsetKey sphereKey = sphere.getSubsetKey();
            String sphereName = sphereKey.getSubsetName();
            if (sphereName.equals("admin")) {
                int projetSize = this.motcleMap.size();
                projetArray = new int[projetSize];
                int p = 0;
                for (Motcle motcle : this.motcleMap.values()) {
                    projetArray[p] = motcle.getId();
                    ++p;
                }
            } else {
                Motcle motcle = this.motcleMap.get(sphereName);
                if (motcle == null) continue;
                projetArray = new int[]{motcle.getId()};
            }
            for (Redacteur redacteur : sphere.getRedacteurList()) {
                RedacteurBundle redacteurBundle = new RedacteurBundle(id, redacteur, projetArray, "");
                this.redacteurMap.put(++id, redacteurBundle);
            }
        }
    }

    private String checkIdalpha(Motcle motcle) {
        String idalpha = motcle.getIdalpha();
        StringBuilder buf = new StringBuilder();
        buf.append('p');
        int length = idalpha.length();
        for (int i = 0; i < length; ++i) {
            char carac = idalpha.charAt(i);
            if (carac == '.') continue;
            buf.append(carac);
        }
        return buf.toString();
    }

    static {
        try {
            projetThesaurusKey = SubsetKey.parse((short)2, (String)"bailleurprojet");
            projetCorpusKey = SubsetKey.parse((short)1, (String)"bailleurprojet");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private class ExportProcess {
        private final Writer writer;

        ExportProcess(Writer writer) {
            this.writer = writer;
        }

        void run() throws IOException {
            this.deleteTables();
            InsertWriter insertWriter = new InsertWriter(this.writer);
            for (String tableName : tables) {
                this.blank();
                if (tableName.equals("utilisateur")) {
                    for (Object redacteurBundle : CeraiComptaSqlExport.this.redacteurMap.values()) {
                        ((RedacteurBundle)redacteurBundle).utilisateurInsert(insertWriter);
                    }
                    continue;
                }
                if (tableName.equals("utilisateur_projet")) {
                    Object redacteurBundle;
                    int startId = 1;
                    redacteurBundle = CeraiComptaSqlExport.this.redacteurMap.values().iterator();
                    while (redacteurBundle.hasNext()) {
                        RedacteurBundle redacteurBundle2 = (RedacteurBundle)redacteurBundle.next();
                        startId = redacteurBundle2.projetUtilisateurInsert(insertWriter, startId);
                    }
                    continue;
                }
                SubsetTable subsetTable = (SubsetTable)CeraiComptaSqlExport.this.subsetTableMap.get(tableName);
                SqlTableWriter sqlTableWriter = new SqlTableWriter(this.writer, tableName);
                TableExportEngine.exportSubset((SubsetTable)subsetTable, (TableWriter)sqlTableWriter, (CellConverter)CeraiComptaSqlExport.this.cellConverter, (Collection)subsetTable.getSubset().getSubsetItemList());
            }
        }

        private void deleteTables() throws IOException {
            int length = tables.length;
            for (int i = length - 1; i >= 0; --i) {
                this.deleteTable(tables[i]);
            }
            this.blank();
        }

        private void deleteTable(String tableName) throws IOException {
            this.writer.write("DELETE FROM ");
            this.writer.write(tableName);
            this.endLine();
        }

        public void endLine() throws IOException {
            this.writer.write(";\n");
        }

        public void blank() throws IOException {
            this.writer.write("\n");
        }
    }

    private class RedacteurBundle {
        private final int id;
        private final Redacteur redacteur;
        private final int[] projetArray;
        private final String md5Password;

        RedacteurBundle(int id, Redacteur redacteur, int[] projetArray, String md5Password) {
            this.id = id;
            this.redacteur = redacteur;
            this.projetArray = projetArray;
            this.md5Password = md5Password;
        }

        void utilisateurInsert(InsertWriter insertWriter) throws IOException {
            insertWriter.startInsert("utilisateur");
            insertWriter.addInteger((long)this.id);
            insertWriter.addText((CharSequence)this.redacteur.getBracketStyle());
            insertWriter.addText((CharSequence)this.md5Password);
            insertWriter.endInsertLine();
        }

        int projetUtilisateurInsert(InsertWriter insertWriter, int startId) throws IOException {
            int length = this.projetArray.length;
            for (int i = 0; i < length; ++i) {
                insertWriter.startInsert("utilisateur_projet");
                insertWriter.addInteger((long)startId);
                insertWriter.addInteger((long)this.projetArray[i]);
                insertWriter.addInteger((long)this.id);
                insertWriter.endInsertLine();
                ++startId;
            }
            return startId;
        }
    }
}

