/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef.htmlpages;

import fr.exemole.bdfext.cef.htmlpages.CefHtmlPage;
import fr.exemole.bdfext.cef.htmlpages.CefHtmlPrinter;
import fr.exemole.bdfext.cef.htmlpages.CefHtmlPrinterUtils;
import fr.exemole.bdfext.cef.htmlpages.PersonneAtelierParFonction;
import fr.exemole.bdfext.cef.htmlpages.PersonneAtelierParFonctionMap;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.HtmlPrinter;

public class AtelierPage
extends CefHtmlPage {
    Motcle atelier;
    private final Corpus personneatelierCorpus;
    private final Thesaurus fonctionThesaurus;
    private final Corpus atelierBiennale;
    private final Thesaurus statutThesaurus;

    public AtelierPage(BdfServer bdfServer, BdfUser bdfUser, Motcle atelier) {
        super(bdfServer, bdfUser);
        this.atelier = atelier;
        this.fonctionThesaurus = this.getThesaurus("fonction0809");
        this.personneatelierCorpus = this.getCorpus("personneatelier2010");
        this.atelierBiennale = this.getCorpus("atelier2010");
        this.statutThesaurus = this.getThesaurus("statut2010");
    }

    @Override
    public CefHtmlPrinter getCefHtmlPrinter() {
        return new AtelierPrinter();
    }

    private class AtelierPrinter
    extends CefHtmlPrinter {
        private AtelierPrinter() {
        }

        @Override
        public void printPage() {
            Junctions junctions;
            String title = AtelierPage.this.atelier.getIdalpha() + " - " + AtelierPage.this.atelier.getLabelString(AtelierPage.this.workingLang);
            this.start(AtelierPage.this.workingLang, title);
            this.H3().__escape((CharSequence)title)._H3();
            Junctions ateliers = AtelierPage.this.fichotheque.getJunctions((SubsetItem)AtelierPage.this.atelier, (Subset)AtelierPage.this.atelierBiennale);
            if (!ateliers.isEmpty()) {
                this.printAtelierBiennale((FicheMeta)ateliers.getFirstSubsetItem());
            }
            if (!(junctions = AtelierPage.this.fichotheque.getJunctions((SubsetItem)AtelierPage.this.atelier, (Subset)AtelierPage.this.getCorpus("personneatelier2010"))).isEmpty()) {
                this.printPersonneAtelierList(junctions);
            }
            this.end();
        }

        private void printPersonneAtelierList(Junctions list) {
            PersonneAtelierParFonctionMap map = new PersonneAtelierParFonctionMap(AtelierPage.this.personneatelierCorpus, AtelierPage.this.fonctionThesaurus);
            map.build(list);
            this.UL();
            for (PersonneAtelierParFonction papf : map.getFonctionMap().values()) {
                Motcle fonction = papf.getFonction();
                this.LI();
                this.DIV();
                this.printMotcle(fonction);
                this._DIV();
                this.UL();
                papf.printLists((HtmlPrinter)this);
                this._UL();
                this._LI();
            }
            this._UL();
        }

        public void printMotcle(Motcle motcle) {
            this.__escape(motcle.getIdalpha()).__escape((CharSequence)" - ").__escape((CharSequence)motcle.getLabelString(AtelierPage.this.workingLang));
        }

        private void printAtelierBiennale(FicheMeta atelierBiennaleFiche) {
            Junctions statutMotcle = AtelierPage.this.fichotheque.getJunctions((SubsetItem)atelierBiennaleFiche, (Subset)AtelierPage.this.statutThesaurus);
            this.P();
            if (!statutMotcle.isEmpty()) {
                this.printMotcle((Motcle)statutMotcle.getFirstSubsetItem());
            }
            this.__escape(" / ").__localize("fiche_atelierbiennale").__escape((CharSequence)" : ");
            CefHtmlPrinterUtils.printLienFiche((HtmlPrinter)this, "atelier2010", atelierBiennaleFiche.getId());
            this._P();
        }
    }
}

