/* UtilLib - Copyright (c) 2011-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.mapeadores.util.format;


/**
 *
 * @author Vincent Calame
 */
public interface FormatConstants {

    /**
     * Catégorie des erreurs sur la source
     */
    public final static String SEVERE_SOURCE = "severe.format.source";
    /**
     * Catégorie des erreurs sur le gabarit
     */
    public final static String SEVERE_PATTERN = "severe.format.pattern";
    /**
     * Catégorie des erreurs sur les instructions
     */
    public final static String SEVERE_INSTRUCTION = "severe.format.instruction";
    /**
     * Catégorie des avertissements sur les instructions
     */
    public final static String WARNING_INSTRUCTION = "warning.format.instruction";
    /**
     * Catégorie des erreurs diverses sur la syntaxe
     */
    public final static String SEVERE_SYNTAX = "severe.format.syntax";
    /**
     * Catégorie des avertissements divers sur la syntaxe
     */
    public final static String WARNING_SYNTAX = "warning.format.syntax";
    /**
     * Catégorie des avertissements sur le contenu de la fichothèque (par
     * exemple, un thésaurus qui n'existe pas)
     */
    public final static String WARNING_FICHOTHEQUE = "warning.format.fichotheque";
    public final static int MAX_POSITION = 999999999;
    public final static int UNDEFINED = -9;
    public final static String INTEGER_CAST = "integer";
    public final static String DECIMAL_CAST = "decimal";
    public final static String DATE_CAST = "date";
    public final static String MONEY_CAST = "money";
    public final static String PERCENTAGE_CAST = "percentage";
    public final static String JSON_CAST = "json";
    public final static String CALCUL_PARAMKEY = "calc";
    public final static String CAST_PARAMKEY = "cast";
    public final static String MAXLENGTH_PARAMKEY = "maxlength";
    public final static String FIXEDLENGTH_PARAMKEY = "fixedlength";
    public final static String FIXEDCHAR_PARAMKEY = "fixedchar";
    public final static String FIXEDEMPTY_PARAMKEY = "fixedempty";
    public final static String DEFAULTVALUE_PARAMKEY = "defval";
    public final static String GLOBALSELECT_PARAMKEY = "globalselect";
    public final static String JSONARRAY_PARAMKEY = "jsonarray";
    public final static String LIMIT_PARAMKEY = "limit";
    public final static String EMPTYTONULL_PARAMKEY = "null";
    public final static String POSITION_PARAMKEY = "pos";
    public final static String POSTTRANSFORM_PARAMKEY = "posttransform";
    public final static String PREFIX_PARAMKEY = "prefix";
    public final static String SEPARATOR_PARAMKEY = "sep";
    public final static String SUFFIX_PARAMKEY = "suffix";
    public final static String SUM_PARAMKEY = "sum";
    public final static String COLUMNSUM_PARAMKEY = "columnsum";
    public final static String UNIQUETEST_PARAMKEY = "unique";
    public final static String FORMULA_PARAMKEY = "formula";
    public final static String LAST_PARAMVALUE = "last";

    public static String checkCastType(String castType) {
        switch (castType) {
            case FormatConstants.INTEGER_CAST:
            case "int":
                return FormatConstants.INTEGER_CAST;
            case FormatConstants.DECIMAL_CAST:
            case "double":
            case "float":
                return FormatConstants.DECIMAL_CAST;
            case FormatConstants.DATE_CAST:
                return FormatConstants.DATE_CAST;
            case FormatConstants.MONEY_CAST:
                return FormatConstants.MONEY_CAST;
            case FormatConstants.PERCENTAGE_CAST:
                return FormatConstants.PERCENTAGE_CAST;
            case FormatConstants.JSON_CAST:
                return FormatConstants.JSON_CAST;
            default:
                throw new IllegalArgumentException("Unknown cast type : " + castType);
        }
    }

}
