/* FichothequeLib_Tools - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.importation.parsers.corpus;

import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.handlers.HandlerUtils;
import net.fichotheque.tools.parsers.FicheParser;
import net.mapeadores.util.primitives.FuzzyDate;


/**
 *
 * @author Vincent Calame
 */
abstract class EditRowParser extends CorpusRowParser {

    final EditCorpusImportBuilder editCorpusImportBuilder;
    final ParseResultBuilder parseResultBuilder;
    final FicheParser ficheParser;
    final CorpusColumns corpusColumns;
    final ImportationParseContext parseContext;
    final Corpus corpus;

    EditRowParser(EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser ficheParser, CorpusColumns corpusColumns, ImportationParseContext parseContext) {
        this.editCorpusImportBuilder = editCorpusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.ficheParser = ficheParser;
        this.corpusColumns = corpusColumns;
        this.parseContext = parseContext;
        this.corpus = editCorpusImportBuilder.getCorpus();
    }

    @Override
    public EditCorpusImportBuilder getCorpusImportBuilder() {
        return editCorpusImportBuilder;
    }

    void populate(EditFicheImportBuilder ficheImportBuilder, Row row) {
        if (corpusColumns.hasFicheHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getFicheChangeBuilder(), corpusColumns.getFicheHandlerArray(), row, ficheParser);
        }
        if (corpusColumns.hasAttributeHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getAttributeChangeBuilder(), corpusColumns.getAttributeHandlerArray(), row);
        }
        if (corpusColumns.hasJunctionHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getTiesImportBuilder(), corpusColumns.getJunctionHandlers(), row, editCorpusImportBuilder.getCorpus(), parseContext);
        }
    }

    void setCreationDate(EditFicheImportBuilder ficheImportBuilder, int rowNumber, Row row) {
        int creationDateIndex = corpusColumns.getCreationDateIndex();
        if ((creationDateIndex != -1) && (row.getColumnCount() > creationDateIndex)) {
            String creationDateString = row.getColumnValue(creationDateIndex).trim();
            try {
                FuzzyDate creationDate = FuzzyDate.parse(creationDateString);
                ficheImportBuilder.setCreationDate(creationDate);
            } catch (ParseException die) {
                parseResultBuilder.wrongDate(rowNumber, creationDateString);
            }
        }
    }

}
