/* FichothequeLib_Tools - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.importation.parsers;

import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.mapeadores.util.localisation.Lang;


/**
 *
 * @author Vincent Calame
 */
public class ImportationParseContext {

    private final FichothequeQuestioner fichothequeQuestioner;
    private final ThesaurusLangChecker thesaurusLangChecker;
    private final Lang workingLang;
    private PolicyProvider policyProvider;
    private FicheItems defaultOwners;

    public ImportationParseContext(FichothequeQuestioner fichothequeQuestioner, ThesaurusLangChecker thesaurusLangChecker, Lang workingLang) {
        this.fichothequeQuestioner = fichothequeQuestioner;
        this.thesaurusLangChecker = thesaurusLangChecker;
        this.workingLang = workingLang;
    }

    public FichothequeQuestioner getFichothequeQuestioner() {
        return fichothequeQuestioner;
    }

    public PolicyProvider getPolicyProvider() {
        return policyProvider;
    }

    public Lang getWorkingLang() {
        return workingLang;
    }

    public ThesaurusLangChecker getThesaurusLangChecker() {
        return thesaurusLangChecker;
    }

    public FicheItems getDefaultOwners() {
        return defaultOwners;
    }

    public ImportationParseContext setPolicyProvider(PolicyProvider policyProvider) {
        this.policyProvider = policyProvider;
        return this;
    }

    public ImportationParseContext setDefaultOwners(FicheItems defaultOwners) {
        this.defaultOwners = defaultOwners;
        return this;
    }

    public static ImportationParseContext init(FichothequeQuestioner fichothequeQuestioner, ThesaurusLangChecker thesaurusLangChecker, Lang workingLang) {
        return new ImportationParseContext(fichothequeQuestioner, thesaurusLangChecker, workingLang);
    }

}
