/* FichothequeLib_Tools - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.exportation.table;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.utils.TableExportUtils;
import net.fichotheque.exportation.table.JunctionTable;


/**
 *
 * @author Vincent Calame
 */
public class TableExportBuilder {

    private final List<SubsetTable> subsetTableList = new ArrayList<SubsetTable>();
    private final List<JunctionTable> junctionTableList = new ArrayList<JunctionTable>();
    private TableExportDef tableExportDef;

    public TableExportBuilder() {

    }

    public TableExportBuilder setTableExportDef(TableExportDef tableExportDef) {
        this.tableExportDef = tableExportDef;
        return this;
    }

    public TableExportBuilder addSubsetTable(SubsetTable subsetTable) {
        if (subsetTable == null) {
            throw new IllegalArgumentException("subsetTable is null");
        }
        subsetTableList.add(subsetTable);
        return this;
    }

    public TableExportBuilder addJunctionTable(JunctionTable junctionTable) {
        if (junctionTable == null) {
            throw new IllegalArgumentException("subsetTable is null");
        }
        junctionTableList.add(junctionTable);
        return this;
    }

    public TableExport toTableExport() {
        List<SubsetTable> finalSubsetTableList = TableExportUtils.wrap(subsetTableList.toArray(new SubsetTable[subsetTableList.size()]));
        List<JunctionTable> finalJunctionTableList = TableExportUtils.wrap(junctionTableList.toArray(new JunctionTable[junctionTableList.size()]));
        return new InternalTableExport(tableExportDef, finalSubsetTableList, finalJunctionTableList);
    }

    public static TableExportBuilder init() {
        return new TableExportBuilder();
    }


    private static class InternalTableExport implements TableExport {

        private final TableExportDef tableExportDef;
        private final List<SubsetTable> subsetTableList;
        private final List<JunctionTable> junctionTableList;

        private InternalTableExport(TableExportDef tableExportDef, List<SubsetTable> subsetTableList, List<JunctionTable> junctionTableList) {
            this.tableExportDef = tableExportDef;
            this.subsetTableList = subsetTableList;
            this.junctionTableList = junctionTableList;
        }

        @Override
        public TableExportDef getTableExportDef() {
            return tableExportDef;
        }

        @Override
        public List<SubsetTable> getSubsetTableList() {
            return subsetTableList;
        }

        @Override
        public List<JunctionTable> getJunctionTableList() {
            return junctionTableList;
        }

    }

}
