/* FichothequeLib_API - Copyright (c) 2011-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.utils.selection;

import net.fichotheque.album.Illustration;
import net.fichotheque.selection.IllustrationQuery;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.SelectionContext;


/**
 *
 * @author Vincent Calame
 */
class IllustrationSelectEngine {

    private final JunctionCondition junctionCondition;

    IllustrationSelectEngine(IllustrationQuery illustrationQuery, JunctionCondition junctionCondition, SelectionContext selectionContext) {
        this.junctionCondition = junctionCondition;
    }

    void filter(Illustration illustration, FilteredJunctionBuilder builder) {
        if (!isSelected(illustration)) {
            return;
        }
        builder.testCondition(junctionCondition);
    }

    boolean isSelected(Illustration illustration) {
        return true;
    }

}
