/* FichothequeLib_API - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.thesaurus.policies;

import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.externalsource.ExternalSourceDef;
import net.fichotheque.thesaurus.Thesaurus;


/**
 *
 * @author Vincent Calame
 */
public interface DynamicEditPolicy {

    public static String NONE_TYPE = "none";
    public static String ALLOW_TYPE = "allow";
    public static String CHECK_TYPE = "check";
    public static String TRANSFER_TYPE = "transfer";
    public static String EXTERNAL_TYPE = "external";

    public String getType();

    public default boolean isLax() {
        return false;
    }

    public default boolean isValid(Thesaurus thesaurus) {
        switch (getType()) {
            case ALLOW_TYPE:
            case CHECK_TYPE:
                return thesaurus.isBabelienType();
            case TRANSFER_TYPE:
                if ((thesaurus.isBabelienType()) || (thesaurus.isMultiType())) {
                    return true;
                } else {
                    return false;
                }
            default:
                return true;
        }
    }


    public static interface None extends DynamicEditPolicy {

        @Override
        public default String getType() {
            return NONE_TYPE;
        }

    }


    public static interface Allow extends DynamicEditPolicy {

        @Override
        public default boolean isLax() {
            return true;
        }

        @Override
        public default String getType() {
            return ALLOW_TYPE;
        }

    }


    public static interface Check extends DynamicEditPolicy {

        public List<SubsetKey> getCheckSubseKeyList();

        @Override
        public default boolean isLax() {
            return true;
        }

        @Override
        public default String getType() {
            return CHECK_TYPE;
        }

    }


    public static interface Transfer extends DynamicEditPolicy {

        public SubsetKey getTransferThesaurusKey();

        @Override
        public default String getType() {
            return TRANSFER_TYPE;
        }

    }


    public static interface External extends DynamicEditPolicy {

        public ExternalSourceDef getExternalSourceDef();

        @Override
        public default String getType() {
            return EXTERNAL_TYPE;
        }

    }

}
