/* FichothequeLib_API - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.sphere;


/**
 *
 * @author Vincent Calame
 */
public class UserLoginException extends Exception {

    public final static String MALFORMED_KEY = "malformed_key";
    public final static String UNKNOWN_SPHERE = "unknown_sphere";
    public final static String UNKNOWN_LOGIN = "unknown_login";

    private final String type;

    public UserLoginException(String type) {
        super(type);
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public boolean isMalformedKey() {
        return (type.equals(MALFORMED_KEY));
    }

    public boolean isUnknownSphere() {
        return (type.equals(UNKNOWN_SPHERE));
    }

    public boolean isUnknownLogin() {
        return (type.equals(UNKNOWN_LOGIN));
    }

}
