/* FichothequeLib_API - Copyright (c) 2017-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.json;

import java.io.IOException;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Info;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.syntax.FicheblockSyntax;
import net.fichotheque.syntax.FormSyntax;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.SeparatorOptions;


/**
 *
 * @author Vincent Calame
 */
public final class FicheJson {

    private FicheJson() {

    }

    public static void properties(JSONWriter jsonWriter, Corpus corpus, FicheAPI fiche, FichothequeQuestioner fichothequeQuestioner) throws IOException {
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        jsonWriter.key(FieldKey.SPECIAL_TITLE);
        jsonWriter.value(fiche.getTitle());
        ParaItem subtitle = fiche.getSubtitle();
        if (subtitle != null) {
            jsonWriter.key(FieldKey.SPECIAL_SUBTITLE);
            jsonWriter.value(FormSyntax.toString(subtitle, fichothequeQuestioner, null));
        }
        Lang lang = fiche.getLang();
        if (lang != null) {
            jsonWriter.key(FieldKey.SPECIAL_LANG);
            jsonWriter.value(lang.toString());
        }
        FicheItems owners = fiche.getOwners();
        if (owners != null) {
            jsonWriter.key(FieldKey.SPECIAL_OWNERS);
            jsonWriter.value(FormSyntax.toString(owners, fichothequeQuestioner, FormSyntax.DEFAULT_INLINE_SEPARATOROPTIONS, null));
        }
        for (Prop prop : fiche.getPropList()) {
            jsonWriter.key(prop.getFieldKey().getKeyString());
            jsonWriter.value(FormSyntax.toString(prop.getFicheItem(), fichothequeQuestioner, null));
        }
        for (Info info : fiche.getInfoList()) {
            FieldKey infoFieldKey = info.getFieldKey();
            SeparatorOptions separatorOptions = FormSyntax.DEFAULT_INLINE_SEPARATOROPTIONS;
            CorpusField corpusField = corpusMetadata.getCorpusField(infoFieldKey);
            if (corpusField != null) {
                if (corpusField.isBlockDisplayInfoField()) {
                    separatorOptions = FormSyntax.DEFAULT_BLOCK_SEPARATOROPTIONS;
                }
            }
            jsonWriter.key(infoFieldKey.getKeyString());
            jsonWriter.value(FormSyntax.toString(info, fichothequeQuestioner, separatorOptions, null));
        }
        FicheblockSyntax.Parameters ficheBlockFormSyntaxParameters = FicheblockSyntax.parameters().withSpecialParseChars(true);
        for (Section section : fiche.getSectionList()) {
            jsonWriter.key(section.getFieldKey().getKeyString());
            jsonWriter.value(FicheblockSyntax.toString(section, ficheBlockFormSyntaxParameters));
        }
    }

}
