/* FichothequeLib_API - Copyright (c) 2006-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque;

import java.text.ParseException;
import java.util.List;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.album.Album;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.JunctionKey;
import net.fichotheque.junction.JunctionRevision;
import net.fichotheque.junction.Junctions;
import net.fichotheque.metadata.FichothequeMetadata;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Thesaurus;


/**
 *
 * @author Vincent Calame
 */
public interface Fichotheque {

    public FichothequeMetadata getFichothequeMetadata();

    public Subset getSubset(SubsetKey subsetKey);

    public Junction getJunction(SubsetItem subsetItem1, SubsetItem subsetItem2);

    public JunctionRevision getJunctionRevision(JunctionKey junctionKey, String revisionName);

    /**
     * Liste des croisements entre un élément et une collection. Cette liste
     * peut être synchronisée, sans que cela soit obligatoire, il est préférable
     * de ne pas faire de modification sur les croisements lorsqu'on fait une
     * itération dessus.
     */
    public Junctions getJunctions(SubsetItem subsetItem, Subset subset);

    public void addFichothequeListener(FichothequeListener fichothequeListener);

    public void removeFichothequeListener(FichothequeListener fichothequeListener);

    public boolean isRemoveable(Subset subset);

    public boolean isRemoveable(SubsetItem subsetItem);

    /**
     * Liste non synchronisée (immutable)
     *
     * @return
     */
    public List<Corpus> getCorpusList();

    public List<Thesaurus> getThesaurusList();

    public List<Sphere> getSphereList();

    public List<Album> getAlbumList();

    public List<Addenda> getAddendaList();

    public default boolean containsSubset(SubsetKey subsetKey) {
        return (getSubset(subsetKey) != null);
    }

    public default Subset getSubset(short category, String subsetName) {
        try {
            SubsetKey subsetKey = SubsetKey.parse(category, subsetName);
            return getSubset(subsetKey);
        } catch (ParseException pe) {
            return null;
        }
    }

    public default Corpus getCorpus(String corpusName) {
        return (Corpus) getSubset(SubsetKey.CATEGORY_CORPUS, corpusName);
    }

    public default Thesaurus getThesaurus(String thesaurusName) {
        return (Thesaurus) getSubset(SubsetKey.CATEGORY_THESAURUS, thesaurusName);
    }

    public default Addenda getAddenda(String addendaName) {
        return (Addenda) getSubset(SubsetKey.CATEGORY_ADDENDA, addendaName);
    }

    public default Album getAlbum(String albumName) {
        return (Album) getSubset(SubsetKey.CATEGORY_ALBUM, albumName);
    }

    public default Sphere getSphere(String sphereName) {
        return (Sphere) getSubset(SubsetKey.CATEGORY_SPHERE, sphereName);
    }

}
