/* BdfServer_Multi - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.multi.subscribe;

import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;


/**
 *
 * @author Vincent Calame
 */
public class SubscribeToken {

    private final static long EXPIRATION = 12 * 60 * 60 * 1000;
    private final static long REMOVEABLE = 3 * 24 * 60 * 60 * 1000;
    private final String token;
    private final PersonCore person;
    private final EmailCore email;
    private final long creationTime;
    private boolean used = false;


    public SubscribeToken(String token, PersonCore person, EmailCore email) {
        this.token = token;
        this.person = person;
        this.email = email;
        this.creationTime = System.currentTimeMillis();
    }

    public String getToken() {
        return token;
    }

    public PersonCore getPerson() {
        return person;
    }

    public EmailCore getEmail() {
        return email;
    }

    public boolean isExpired() {
        long currentTime = System.currentTimeMillis();
        if ((currentTime - creationTime) > EXPIRATION) {
            return true;
        } else {
            return false;
        }
    }

    public boolean isRemoveable() {
        long currentTime = System.currentTimeMillis();
        if ((currentTime - creationTime) > REMOVEABLE) {
            return true;
        } else {
            return false;
        }
    }

    public boolean isUsed() {
        return used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

}
