/* BdfServer_DirectoryStorage - Copyright (c) 2008-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.storage.directory.oldversions;

import java.util.Collections;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.junction.Tie;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import net.fichotheque.junction.JunctionChange;
import net.fichotheque.junction.JunctionEditor;


/**
 *
 * @author Vincent Calame
 */
public class OldJunctionDOMReader {

    private final MessageHandler messageHandler;

    public OldJunctionDOMReader(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void readJunction(JunctionEditor junctionEditor, Subset subset1, Subset subset2, Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); i++) {
            Node nd = liste.item(i);
            if (nd.getNodeType() == Node.ELEMENT_NODE) {
                Element el = (Element) nd;
                String tagname = el.getTagName();
                if (tagname.equals("ci")) {
                    try {
                        InternalJunctionChange junctionChange = getJunctionChange(subset1, subset2, el);
                        if (junctionChange != null) {
                            junctionEditor.updateJunction(junctionChange.subsetItem1, junctionChange.subsetItem2, junctionChange);
                        }
                    } catch (IllegalArgumentException iae) {
                    }
                } else {
                    DomMessages.unknownTagWarning(messageHandler, tagname);
                }
            }
        }
    }

    private InternalJunctionChange getJunctionChange(Subset subset1, Subset subset2, Element element) {
        int id1 = getAttribute(element, "id1", false);
        SubsetItem subsetItem1 = subset1.getSubsetItemById(id1);
        if (subsetItem1 == null) {
            return null;
        }
        int id2 = getAttribute(element, "id2", false);
        SubsetItem subsetItem2 = subset2.getSubsetItemById(id2);
        if (subsetItem2 == null) {
            return null;
        }
        int weight = getAttribute(element, "poids", true);
        if (weight == -1) {
            weight = 1;
        }
        int position1 = getAttribute(element, "pos1", true) + 1;
        int position2 = getAttribute(element, "pos2", true) + 1;
        Tie tie = JunctionUtils.toTie("", weight, position1, position2);
        return new InternalJunctionChange(subsetItem1, subsetItem2, tie);
    }

    private int getAttribute(Element element, String name, boolean emptyallowed) {
        String s = element.getAttribute(name);
        if (s.length() == 0) {
            if (emptyallowed) {
                return -1;
            }
            DomMessages.emptyAttribute(messageHandler, element.getTagName(), name);
            throw new IllegalArgumentException();
        }
        try {
            int entier = Integer.parseInt(s);
            if (entier < 0) {
                entier = -1;
            }
            return entier;
        } catch (NumberFormatException nfe) {
            DomMessages.wrongIntegerAttributeValue(messageHandler, element.getTagName(), name, s);
            throw new IllegalArgumentException();
        }
    }


    private static class InternalJunctionChange implements JunctionChange {

        private final List<Tie> tieList;
        private final SubsetItem subsetItem1;
        private final SubsetItem subsetItem2;

        private InternalJunctionChange(SubsetItem subsetItem1, SubsetItem subsetItem2, Tie lien) {
            this.tieList = Collections.singletonList(lien);
            this.subsetItem1 = subsetItem1;
            this.subsetItem2 = subsetItem2;
        }

        @Override
        public List<String> getRemovedModeList() {
            return JunctionUtils.EMPTY_REMOVEDMODELIST;
        }

        @Override
        public List<Tie> getChangedTieList() {
            return tieList;
        }

    }

}
