/* BdfServer_Commands - Copyright (c) 2015-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.interaction.Domains;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.album.Illustration;
import net.fichotheque.junction.JunctionChanges;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.fichotheque.tools.junction.TieBuffer;
import net.fichotheque.tools.parsers.junction.TieBufferParser;
import net.fichotheque.tools.permission.PermissionPredicate;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;


/**
 *
 * @author Vincent Calame
 */
public class JunctionAddCommand extends AbstractBdfCommand {

    public final static String COMMANDNAME = "JunctionAdd";
    public final static String COMMANDKEY = "_ ALB-14";
    public final static String ADD_PARAMNAME = "add";
    private Illustration illustration;
    private JunctionChanges junctionChanges;

    public JunctionAddCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = startEditSession(Domains.ALBUM, COMMANDNAME)) {
            session.getFichothequeEditor().getJunctionEditor().updateJunctions(illustration, junctionChanges);
        }
        putResultObject(ALBUM_OBJ, illustration.getAlbum());
        putResultObject(ILLUSTRATION_OBJ, illustration);
        setDone("_ done.album.junctionadd");
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        illustration = requestHandler.getMandatoryIllustration();
        getPermissionChecker()
                .checkWrite(illustration);
        PermissionPredicate predicate = PermissionPredicate.read(getPermissionSummary());
        String addString = getMandatory(ADD_PARAMNAME);
        String[] tokens = StringUtils.getTechnicalTokens(addString, false);
        JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendEngine(illustration);
        boolean done = false;
        for (String token : tokens) {
            try {
                TieBuffer tieBuffer = TieBufferParser.parse(bdfServer.getFichothequeQuestioner(), token, SubsetKey.CATEGORY_CORPUS);
                if (predicate.test(tieBuffer.getSubsetItem())) {
                    junctionChangeEngine.addTie(tieBuffer);
                    done = true;
                }
            } catch (ParseException e) {

            }
        }
        if (!done) {
            throw BdfErrors.error("_ error.wrong.fichekeys");
        }
        junctionChanges = junctionChangeEngine.toJunctionChanges();
    }

}
