/* BdfServer_API - Copyright (c) 2009-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.api.ficheform.include;

import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.exportation.table.SubsetTable;
import fr.exemole.bdfserver.api.ficheform.FormEntry;


/**
 *
 * @author Vincent Calame
 */
public interface CorpusEntry extends FormEntry.Include {

    public Corpus getCorpus();

    public List<SubsetItemValue> getValueList();


    public interface Check extends CorpusEntry {

        public boolean hasWeightFilter();

    }


    public interface Table extends CorpusEntry {

        public SubsetTable getSubsetTable();

        public CellConverter getCellConverter();

    }

}
