/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.io.Serializable;

public final class SubstringPosition
implements Serializable,
Comparable {
    private final int beginIndex;
    private final int length;

    public SubstringPosition(int beginIndex, int length) {
        this.beginIndex = beginIndex;
        this.length = length;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getLength() {
        return this.length;
    }

    public int getEndIndex() {
        return this.beginIndex + this.length - 1;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof SubstringPosition)) {
            return false;
        }
        SubstringPosition sp = (SubstringPosition)other;
        return sp.beginIndex == this.beginIndex && sp.length == this.length;
    }

    public int hashCode() {
        return this.beginIndex * 1000 + this.length;
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        SubstringPosition sp = (SubstringPosition)obj;
        if (this.beginIndex == sp.beginIndex) {
            if (this.length == sp.length) {
                return 0;
            }
            return this.length < sp.length ? -1 : 1;
        }
        return this.beginIndex < sp.beginIndex ? -1 : 1;
    }

    public boolean contains(SubstringPosition substringPosition) {
        return substringPosition.beginIndex >= this.beginIndex && substringPosition.length <= this.length;
    }

    public static SubstringPosition merge(SubstringPosition sp1, SubstringPosition sp2) {
        int comp = sp1.compareTo(sp2);
        if (comp == 0) {
            return sp1;
        }
        if (comp < 0) {
            return SubstringPosition.mergeInOrder(sp1, sp2);
        }
        return SubstringPosition.mergeInOrder(sp2, sp1);
    }

    private static SubstringPosition mergeInOrder(SubstringPosition sp1, SubstringPosition sp2) {
        int start = sp1.beginIndex;
        int length = sp2.beginIndex - sp1.beginIndex + sp2.length;
        return new SubstringPosition(start, length);
    }
}

