/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets.handlers;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.servlets.ResponseHandler;

public class StreamResponseHandler
implements ResponseHandler {
    private final StreamProducer streamProducer;
    private long lastModified = -1L;
    private String mimeType = "application/octet-stream";
    private String charset = null;
    private String fileName = null;
    private int length = -1;

    public StreamResponseHandler(StreamProducer streamProducer) {
        this.streamProducer = streamProducer;
        String producerMimeType = streamProducer.getMimeType();
        if (producerMimeType != null) {
            this.mimeType = producerMimeType;
        }
        this.charset = streamProducer.getCharset();
        this.fileName = streamProducer.getFileName();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    public StreamResponseHandler lastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Override
    public void handleResponse(HttpServletResponse response) throws IOException {
        String contentType = this.mimeType;
        if (this.charset != null) {
            contentType = contentType + ";charset=" + this.charset;
        }
        response.setContentType(contentType);
        if (this.length > -1) {
            response.setContentLength(this.length);
        }
        if (this.fileName != null) {
            response.setHeader("Content-Disposition", "attachment; filename=" + this.fileName);
        }
        try (ServletOutputStream output = response.getOutputStream();){
            this.streamProducer.writeStream((OutputStream)output);
        }
    }

    public static StreamResponseHandler init(StreamProducer streamProducer) {
        return new StreamResponseHandler(streamProducer);
    }
}

