/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.MultiPartParser;
import net.mapeadores.util.text.UTF8Bridge;

public class HttpServletRequestMap
implements RequestMap {
    protected HttpServletRequest request;
    protected UTF8Bridge utf8Bridge;
    private Map<String, Object> multiPartValueMap;
    private boolean xmlHttpRequest = false;

    public HttpServletRequestMap(HttpServletRequest request) {
        this(request, null);
    }

    public HttpServletRequestMap(HttpServletRequest request, MultiPartParser multiPartParser) {
        String xmlHttpRequestHeader;
        this.request = request;
        this.utf8Bridge = new UTF8Bridge(request.getCharacterEncoding());
        if (multiPartParser != null && multiPartParser.isMultiPartContentRequest(request)) {
            this.multiPartValueMap = multiPartParser.parseMultiPartContentRequest(request);
        }
        if ((xmlHttpRequestHeader = request.getHeader("X-Requested-With")) != null && xmlHttpRequestHeader.equals("XMLHttpRequest")) {
            this.xmlHttpRequest = true;
        }
    }

    @Override
    public FileValue getFileValue(String name) {
        if (this.multiPartValueMap != null) {
            Object obj = this.multiPartValueMap.get(name);
            if (obj instanceof FileValue) {
                return (FileValue)obj;
            }
            if (obj instanceof FileValue[]) {
                FileValue[] result = (FileValue[])obj;
                return result[0];
            }
            return null;
        }
        return null;
    }

    @Override
    public FileValue[] getFileValues(String name) {
        if (this.multiPartValueMap != null) {
            Object obj = this.multiPartValueMap.get(name);
            if (obj instanceof FileValue) {
                FileValue[] result = new FileValue[]{(FileValue)obj};
                return result;
            }
            if (obj instanceof FileValue[]) {
                return (FileValue[])obj;
            }
            return null;
        }
        return null;
    }

    @Override
    public Object getSourceObject() {
        return this.request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public String getParameter(String name) {
        if (this.multiPartValueMap != null) {
            Object obj = this.multiPartValueMap.get(name);
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof String[]) {
                return ((String[])obj)[0];
            }
            return null;
        }
        return this.utf8Bridge.toUTF8(this.request.getParameter(name));
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this.multiPartValueMap != null) {
            Object obj = this.multiPartValueMap.get(name);
            if (obj instanceof String) {
                String[] result = new String[]{(String)obj};
                return result;
            }
            if (obj instanceof String[]) {
                return (String[])obj;
            }
            return null;
        }
        String[] paramValues = this.request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        int length = paramValues.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.utf8Bridge.toUTF8(paramValues[i]);
        }
        return result;
    }

    @Override
    public Set<String> getParameterNameSet() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.multiPartValueMap != null) {
            hashSet.addAll(this.multiPartValueMap.keySet());
        } else {
            Enumeration enumeration = this.request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String paramName = (String)enumeration.nextElement();
                hashSet.add(paramName);
            }
        }
        return hashSet;
    }

    public boolean isXMLHttpRequest() {
        return this.xmlHttpRequest;
    }

    @Override
    public Locale[] getAcceptableLocaleArray() {
        ArrayList<Locale> localeList = new ArrayList<Locale>();
        Enumeration enumeration = this.request.getLocales();
        while (enumeration.hasMoreElements()) {
            Locale locale = (Locale)enumeration.nextElement();
            localeList.add(locale);
        }
        return localeList.toArray(new Locale[localeList.size()]);
    }
}

