/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io.docstream;

import java.io.IOException;
import java.io.InputStream;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.mimetype.MimeTypeUtils;

public class WrappedDocStream
implements DocStream {
    private final DocStream docStream;
    private String mimeType = "application/octet-stream";
    private String charset = null;

    public WrappedDocStream(DocStream docStream) {
        this.docStream = docStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.docStream.getInputStream();
    }

    @Override
    public int getLength() {
        return this.docStream.getLength();
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        this.mimeType = mimeType;
        this.charset = MimeTypeUtils.getDefaultCharset(mimeType);
    }

    public void setMimeType(String mimeType, String charset) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        this.mimeType = mimeType;
        this.charset = charset;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public long getLastModified() {
        return this.docStream.getLastModified();
    }
}

