/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.function.Consumer;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.io.IOUtils;

public class TempStorageAppendable
implements Appendable,
Consumer<Writer> {
    private static final int MAX_LENGTH = 0x100000;
    private StringBuilder memoryStorage = new StringBuilder(0x100400);
    private BufferedWriter fileStorage;
    private File tempFile;
    private boolean onMemory = true;
    private Appendable currentAppendable = this.memoryStorage;

    @Override
    public Appendable append(CharSequence cs) throws IOException {
        this.testMemory();
        this.currentAppendable.append(cs);
        return this.currentAppendable;
    }

    @Override
    public Appendable append(CharSequence cs, int start, int end) throws IOException {
        this.testMemory();
        this.currentAppendable.append(cs, start, end);
        return this.currentAppendable;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.testMemory();
        this.currentAppendable.append(c);
        return this.currentAppendable;
    }

    private void testMemory() throws IOException {
        if (this.onMemory && this.memoryStorage.length() > 0x100000) {
            this.tempFile = File.createTempFile("tempstorage", null);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.tempFile), "UTF-8");
            ((Writer)writer).append(this.memoryStorage);
            this.memoryStorage = null;
            this.onMemory = false;
            this.fileStorage = new BufferedWriter(writer);
            this.currentAppendable = this.fileStorage;
        }
    }

    @Override
    public void accept(Writer destination) {
        try {
            this.flush(destination);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    public void flush(Writer destination) throws IOException {
        if (this.onMemory) {
            destination.append(this.memoryStorage);
            this.memoryStorage = null;
        } else {
            this.fileStorage.flush();
            this.fileStorage.close();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.tempFile), "UTF-8"));){
                IOUtils.copy((Reader)reader, destination);
            }
            this.tempFile.delete();
        }
    }
}

