/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.http;

import net.mapeadores.util.http.RedirectionUrl;

public final class UrlStatus {
    public static final String BAD_HTTP = "bad_http";
    public static final String HTTP_ERROR = "http_error";
    public static final String MALFORMED = "malformed";
    public static final String MISSING_REDIRECTION = "missing_redirection";
    public static final String NOT_FOUND = "not_found";
    public static final String OK = "ok";
    public static final String REDIRECTION = "redirection";
    public static final String REDIRECTION_LIMIT = "redirection_limit";
    public static final String RELATIVE = "relative";
    public static final String TIMEOUT = "timeout";
    public static final String UNKNOWN_PROTOCOL = "unknown_protocol";
    public static final String UNREACHABLE = "unreachable";
    private final String state;
    private final int responseCode;
    private final String responseMessage;
    private final RedirectionUrl redirectionUrl;

    UrlStatus(String state) {
        this.state = state;
        this.responseCode = -1;
        this.responseMessage = null;
        this.redirectionUrl = null;
    }

    UrlStatus(String state, int responseCode, String responseMessage, RedirectionUrl redirectionUrl) {
        this.state = state;
        this.responseCode = responseCode;
        if (responseMessage == null) {
            responseMessage = "";
        }
        this.responseMessage = responseMessage;
        this.redirectionUrl = redirectionUrl;
    }

    public String getState() {
        return this.state;
    }

    public boolean hasResponse() {
        return this.responseCode > 0;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public RedirectionUrl getRedirectionUrl() {
        return this.redirectionUrl;
    }

    public String toString() {
        if (this.responseCode > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.state);
            buf.append(" (");
            buf.append(this.responseCode);
            if (!this.responseMessage.isEmpty()) {
                buf.append(" ");
                buf.append(this.responseMessage);
            }
            buf.append(")");
            if (this.redirectionUrl != null) {
                buf.append(" / ");
                buf.append(this.redirectionUrl.toString());
            }
            return buf.toString();
        }
        return this.state;
    }
}

