/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html;

import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.TrustedHtml;
import net.mapeadores.util.localisation.Lang;

public class PageHtmlPrinter
extends HtmlPrinter {
    private final List<HtmlAttributes> iconAttributesList = new ArrayList<HtmlAttributes>();
    private final List<String> cssUrlList = new ArrayList<String>();
    private final List<String> jsUrlList = new ArrayList<String>();
    private HtmlAttributes bodyHTMLAttributes = null;
    private String bodyCssClass = null;
    private List<TrustedHtml> cssStyleList = null;

    public final PageHtmlPrinter setBodyHTMLAttributes(HtmlAttributes bodyHTMLAttributes) {
        this.bodyHTMLAttributes = bodyHTMLAttributes;
        return this;
    }

    public final PageHtmlPrinter setBodyCssClass(String bodyCssClass) {
        this.bodyCssClass = bodyCssClass;
        return this;
    }

    public final void addStyle(TrustedHtml cssStyle) {
        if (this.cssStyleList == null) {
            this.cssStyleList = new ArrayList<TrustedHtml>();
        }
        this.cssStyleList.add(cssStyle);
    }

    public PageHtmlPrinter addCssUrl(String cssUrl) {
        this.cssUrlList.add(cssUrl);
        return this;
    }

    public PageHtmlPrinter addJsUrl(String jsUrl) {
        this.jsUrlList.add(jsUrl);
        return this;
    }

    public void start(Lang lang, String title) {
        this.DOCTYPE_html5().HTML(lang);
        this.HEAD();
        this.TITLE().__escape(title)._TITLE();
        this.META_htmlcontenttype();
        if (!this.jsUrlList.isEmpty()) {
            this.META(HA.httpEquiv("Content-Script-Type").content("text/javascript"));
        }
        for (String cssUrl : this.cssUrlList) {
            this.LINK(HA.type("text/css").href(cssUrl).rel("stylesheet"));
        }
        for (HtmlAttributes iconAttributes : this.iconAttributesList) {
            this.LINK(iconAttributes);
        }
        if (!this.jsUrlList.isEmpty()) {
            HtmlAttributes scriptAttributes = HA.type("text/javascript");
            int length = this.jsUrlList.size();
            for (int i = 0; i < length; ++i) {
                scriptAttributes.src(this.jsUrlList.get(i));
                this.SCRIPT(scriptAttributes)._SCRIPT();
            }
        }
        if (this.cssStyleList != null) {
            this.STYLE();
            for (TrustedHtml cssStyle : this.cssStyleList) {
                this.__append(cssStyle);
            }
            this._STYLE();
        }
        this._HEAD();
        if (this.bodyHTMLAttributes != null) {
            this.BODY(this.bodyHTMLAttributes);
        } else {
            this.BODY(this.bodyCssClass);
        }
    }

    public void end() {
        this._BODY()._HTML();
    }

    public void addIconPng(String path, String size) {
        this.addIcon(path, size + "x" + size, "image/png", "icon");
    }

    public void addIcon(String path, String sizes, String mimeType, String relType) {
        this.iconAttributesList.add(HA.href(path).type(mimeType).rel(relType).attr("sizes", sizes));
    }

    public void addIcon(HtmlAttributes iconAttributes) {
        this.iconAttributesList.add(iconAttributes);
    }
}

