/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.attr;

import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesBuilder;

public class AttributesCache {
    private final SortedMap<AttributeKey, Attribute> attributeMap = new TreeMap<AttributeKey, Attribute>();
    private Attributes cachedAttributes;

    public synchronized void clear() {
        this.attributeMap.clear();
        this.cachedAttributes = null;
    }

    public synchronized void putAttributes(Attributes attributes) {
        for (Attribute attribute : attributes) {
            this.attributeMap.put(attribute.getAttributeKey(), attribute);
        }
        this.cachedAttributes = null;
    }

    public synchronized boolean putAttribute(Attribute attribute) {
        AttributeKey attributeKey = attribute.getAttributeKey();
        Attribute current = (Attribute)this.attributeMap.get(attributeKey);
        if (current != null && AttributeUtils.isEqual(current, attribute)) {
            return false;
        }
        this.attributeMap.put(attributeKey, attribute);
        this.cachedAttributes = null;
        return true;
    }

    public synchronized boolean removeAttribute(AttributeKey attributeKey) {
        Attribute attribute = (Attribute)this.attributeMap.remove(attributeKey);
        if (attribute != null) {
            this.cachedAttributes = null;
            return true;
        }
        return false;
    }

    public Attributes getAttributes() {
        Attributes result = this.cachedAttributes;
        if (result == null) {
            result = this.cache();
        }
        return result;
    }

    private synchronized Attributes cache() {
        Attributes cache;
        this.cachedAttributes = cache = this.build();
        return cache;
    }

    private synchronized Attributes build() {
        int size = this.attributeMap.size();
        switch (size) {
            case 0: {
                return AttributeUtils.EMPTY_ATTRIBUTES;
            }
            case 1: {
                return AttributeUtils.toSingletonAttributes(this.attributeMap.values().iterator().next());
            }
        }
        Attribute[] attributeArray = this.attributeMap.values().toArray(new Attribute[size]);
        return AttributesBuilder.toAttributes(attributeArray);
    }
}

