/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io.odtable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.io.OdXML;
import net.mapeadores.opendocument.io.StylesXMLPart;
import net.mapeadores.opendocument.io.odtable.CellStyle;
import net.mapeadores.opendocument.io.odtable.OdCellKey;
import net.mapeadores.opendocument.io.odtable.OdColumn;
import net.mapeadores.opendocument.io.odtable.OdColumnDef;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.StyleManager;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.xml.XMLWriter;

public class StyleManagerBuilder {
    private static final String ISODATE_DATASTYLE_NAME = "N101";
    private static final String COLUMNSTYLE_PREFIX = "co";
    private static final String CELLSTYLE_PREFIX = "ce";
    private static final String DATASTYLE_PREFIX = "N";
    private static final String DEFAULT_CELLSTYLE_NAME = "Default";
    private final List<String> columnStyleNameList = new ArrayList<String>();
    private final Map<String, TableInfo> tableInfoMap = new HashMap<String, TableInfo>();
    private final Map<OdCellKey, CellStyle> cellStyleNameMap = new LinkedHashMap<OdCellKey, CellStyle>();
    private final Map<ExtendedCurrency, Integer> currencyNumberMap = new LinkedHashMap<ExtendedCurrency, Integer>();
    private ElementMaps elementMaps = null;
    private boolean withISODate = false;
    private int columnStyleNumber = 1;
    private int cellStyleNumber = 1;
    private int currencyStyleNumber = 102;

    public StyleManagerBuilder putTableDef(String tableName, OdTableDef odTableDef) {
        if (!this.tableInfoMap.containsKey(tableName)) {
            this.tableInfoMap.put(tableName, new TableInfo(odTableDef));
        }
        return this;
    }

    public StyleManagerBuilder addTableDef(OdTableDef odTableDef) {
        String tableName = odTableDef.getTableName();
        if (!this.tableInfoMap.containsKey(tableName)) {
            this.tableInfoMap.put(tableName, new TableInfo(odTableDef));
        }
        return this;
    }

    public StyleManagerBuilder setElementMaps(ElementMaps elementMaps) {
        this.elementMaps = elementMaps;
        return this;
    }

    public StyleManager toStyleManager() {
        return new InternalStyleManager();
    }

    private String getNewColumnStyleName() {
        String styleName = COLUMNSTYLE_PREFIX + String.valueOf(this.columnStyleNumber);
        ++this.columnStyleNumber;
        this.columnStyleNameList.add(styleName);
        return styleName;
    }

    private CellStyle initCellStyle(OdCellKey odCellKey) {
        CellStyle cellStyle = this.cellStyleNameMap.get(odCellKey);
        if (cellStyle != null) {
            return cellStyle;
        }
        String name = CELLSTYLE_PREFIX + this.cellStyleNumber;
        ++this.cellStyleNumber;
        String dataStyleName = null;
        switch (odCellKey.getStyleFamliy()) {
            case 1: {
                this.withISODate = true;
                dataStyleName = ISODATE_DATASTYLE_NAME;
                break;
            }
            case 2: {
                int number;
                ExtendedCurrency currency = odCellKey.getCurrency();
                if (this.currencyNumberMap.containsKey(currency)) {
                    number = this.currencyNumberMap.get(currency);
                } else {
                    number = this.currencyStyleNumber++;
                    this.currencyNumberMap.put(currency, number);
                }
                dataStyleName = DATASTYLE_PREFIX + number;
            }
        }
        cellStyle = new CellStyle(name, dataStyleName, odCellKey.getStyleName());
        this.cellStyleNameMap.put(odCellKey, cellStyle);
        return cellStyle;
    }

    public static StyleManagerBuilder init() {
        return new StyleManagerBuilder();
    }

    private class TableInfo {
        private final List<OdColumn> odColumnList = new ArrayList<OdColumn>();

        private TableInfo(OdTableDef odTableDef) {
            for (OdColumnDef columnDef : odTableDef.getOdColumnDefList()) {
                short type = columnDef.getColumnStyleFamily();
                ExtendedCurrency currency = columnDef.getCurrency();
                String customStyleName = columnDef.getCustomStyleName();
                String columnStyleName = null;
                columnStyleName = customStyleName != null ? customStyleName : StyleManagerBuilder.this.getNewColumnStyleName();
                OdCellKey defaultOdCellKey = OdCellKey.newInstance(type, currency, columnDef.getDefaultCellStyleName());
                CellStyle defaultCellStyle = StyleManagerBuilder.this.initCellStyle(defaultOdCellKey);
                this.odColumnList.add(new OdColumn(columnStyleName, defaultOdCellKey, defaultCellStyle));
            }
        }

        private OdCellKey getDefaultOdCellKey(int columnNumber) {
            if (columnNumber > 0 && columnNumber <= this.odColumnList.size()) {
                return this.odColumnList.get(columnNumber - 1).getDefaultOdCellKey();
            }
            return null;
        }
    }

    private class InternalStyleManager
    implements StyleManager {
        private InternalStyleManager() {
        }

        @Override
        public String getCellStyleName(String tableName, int columnNumber, short styleFamily, String parentStyleName) {
            if (styleFamily == 2) {
                throw new IllegalArgumentException("Not use with styleFamily = OdColumnDef.CURRENCY_STYLE_FAMILY");
            }
            OdCellKey odCellKey = OdCellKey.newInstance(styleFamily, parentStyleName);
            return this.getCellStyleName(tableName, columnNumber, odCellKey);
        }

        @Override
        public String getCurrencyStyleName(String tableName, int columnNumber, String parentStyleName, ExtendedCurrency currency) {
            OdCellKey odCellKey = OdCellKey.newInstance((short)2, currency, parentStyleName);
            return this.getCellStyleName(tableName, columnNumber, odCellKey);
        }

        @Override
        public List<OdColumn> getOdColumnList(String tableName) {
            TableInfo tableInfo = (TableInfo)StyleManagerBuilder.this.tableInfoMap.get(tableName);
            if (tableInfo == null) {
                return null;
            }
            return tableInfo.odColumnList;
        }

        @Override
        public void insertAutomaticStyles(XMLWriter xmlWriter) throws IOException {
            if (StyleManagerBuilder.this.elementMaps != null) {
                StylesXMLPart stylesPart = new StylesXMLPart(xmlWriter);
                stylesPart.insertAutomaticStyles(StyleManagerBuilder.this.elementMaps, true);
            }
            for (String string : StyleManagerBuilder.this.columnStyleNameList) {
                boolean done = false;
                if (StyleManagerBuilder.this.elementMaps != null && StyleManagerBuilder.this.elementMaps.getElement("col", string, false) != null) {
                    done = true;
                }
                if (done) continue;
                OdXML.openStyle(xmlWriter, string, "table-column", null);
                xmlWriter.startOpenTag("style:table-column-properties");
                xmlWriter.addAttribute("style:column-width", "3.5cm");
                xmlWriter.closeEmptyTag();
                OdXML.closeStyle(xmlWriter);
            }
            if (StyleManagerBuilder.this.withISODate) {
                xmlWriter.startOpenTag("number:date-style");
                xmlWriter.addAttribute("style:name", StyleManagerBuilder.ISODATE_DATASTYLE_NAME);
                xmlWriter.endOpenTag();
                xmlWriter.startOpenTag("number:year");
                xmlWriter.addAttribute("number:style", "long");
                xmlWriter.closeEmptyTag();
                xmlWriter.addSimpleElement("number:text", "-");
                xmlWriter.startOpenTag("number:month");
                xmlWriter.addAttribute("number:style", "long");
                xmlWriter.closeEmptyTag();
                xmlWriter.addSimpleElement("number:text", "-");
                xmlWriter.startOpenTag("number:day");
                xmlWriter.addAttribute("number:style", "long");
                xmlWriter.closeEmptyTag();
                xmlWriter.closeTag("number:date-style");
            }
            for (Map.Entry entry : StyleManagerBuilder.this.currencyNumberMap.entrySet()) {
                ExtendedCurrency currency = (ExtendedCurrency)entry.getKey();
                int number = (Integer)entry.getValue();
                String dataStyleName = StyleManagerBuilder.DATASTYLE_PREFIX + number;
                int fractionDigits = currency.getDefaultFractionDigits();
                String symbol = currency.getSymbol();
                boolean before = currency.isSymbolBefore();
                xmlWriter.startOpenTag("number:currency-style");
                xmlWriter.addAttribute("style:name", dataStyleName + "P0");
                xmlWriter.addAttribute("style:volatile", "true");
                xmlWriter.endOpenTag();
                if (before) {
                    xmlWriter.addSimpleElement("number:currency-symbol", symbol);
                }
                xmlWriter.startOpenTag("number:number");
                xmlWriter.addAttribute("number:decimal-places", fractionDigits);
                xmlWriter.addAttribute("number:min-integer-digits", "1");
                xmlWriter.addAttribute("number:grouping", "true");
                xmlWriter.closeEmptyTag();
                if (!before) {
                    xmlWriter.addSimpleElement("number:text", " ");
                    xmlWriter.addSimpleElement("number:currency-symbol", symbol);
                }
                xmlWriter.closeTag("number:currency-style");
                xmlWriter.startOpenTag("number:currency-style");
                xmlWriter.addAttribute("style:name", dataStyleName);
                xmlWriter.endOpenTag();
                xmlWriter.startOpenTag("style:text-properties");
                xmlWriter.addAttribute("fo:color", "#ff0000");
                xmlWriter.closeEmptyTag();
                xmlWriter.addSimpleElement("number:text", "-");
                if (before) {
                    xmlWriter.addSimpleElement("number:currency-symbol", symbol);
                }
                xmlWriter.startOpenTag("number:number");
                xmlWriter.addAttribute("number:decimal-places", fractionDigits);
                xmlWriter.addAttribute("number:min-integer-digits", "1");
                xmlWriter.addAttribute("number:grouping", "true");
                xmlWriter.closeEmptyTag();
                if (!before) {
                    xmlWriter.addSimpleElement("number:text", " ");
                    xmlWriter.addSimpleElement("number:currency-symbol", symbol);
                }
                xmlWriter.startOpenTag("style:map");
                xmlWriter.addAttribute("style:condition", "value()>=0");
                xmlWriter.addAttribute("style:apply-style-name", dataStyleName + "P0");
                xmlWriter.closeEmptyTag();
                xmlWriter.closeTag("number:currency-style");
            }
            for (CellStyle cellStyle : StyleManagerBuilder.this.cellStyleNameMap.values()) {
                String parentStyleName = cellStyle.getParentStyleName();
                if (parentStyleName == null) {
                    parentStyleName = StyleManagerBuilder.DEFAULT_CELLSTYLE_NAME;
                }
                OdXML.startStyleOpenTag(xmlWriter, cellStyle.getName(), "table-cell", parentStyleName);
                xmlWriter.addAttribute("style:data-style-name", cellStyle.getDataStyleName());
                xmlWriter.closeEmptyTag();
            }
        }

        private String getCellStyleName(String tableName, int columnNumber, OdCellKey odCellKey) {
            OdCellKey defaultOdCellKey;
            TableInfo tableInfo = (TableInfo)StyleManagerBuilder.this.tableInfoMap.get(tableName);
            if (tableInfo != null && (defaultOdCellKey = tableInfo.getDefaultOdCellKey(columnNumber)) != null && defaultOdCellKey.equals(odCellKey)) {
                return null;
            }
            CellStyle cellStyle = StyleManagerBuilder.this.initCellStyle(odCellKey);
            return cellStyle.getName();
        }
    }
}

