/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.opendocument.io.OdZip;
import net.mapeadores.opendocument.io.Pictures;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public final class OdZipEngine {
    private final ZipOutputStream zipOutputStream;
    private final OdZip odZip;

    private OdZipEngine(ZipOutputStream zipOutputStream, OdZip odZip) {
        this.zipOutputStream = zipOutputStream;
        this.odZip = odZip;
    }

    public static void run(OutputStream destination, OdZip odZip) throws IOException {
        try (ZipOutputStream os = new ZipOutputStream(destination);){
            OdZipEngine engine = new OdZipEngine(os, odZip);
            engine.run();
        }
    }

    private void run() throws IOException {
        this.zipManifest();
        this.zipContent();
        this.zipStyles();
        this.zipSettings();
        this.zipPictures();
    }

    private void zipManifest() throws IOException {
        ZipEntry zipEntry = new ZipEntry("META-INF/manifest.xml");
        this.zipOutputStream.putNextEntry(zipEntry);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.zipOutputStream, "UTF-8"));
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(writer);
        XMLUtils.appendXmlDeclaration(xmlWriter);
        ManifestXMLPart manifestXMLPart = new ManifestXMLPart(xmlWriter, this.odZip);
        manifestXMLPart.writeManifest();
        writer.flush();
        this.zipOutputStream.closeEntry();
    }

    private void zipContent() throws IOException {
        OdSource contentOdSource = this.odZip.contentOdSource();
        ZipEntry zipEntry = new ZipEntry("content.xml");
        this.zipOutputStream.putNextEntry(zipEntry);
        if (contentOdSource != null) {
            contentOdSource.writeStream(this.zipOutputStream);
        } else {
            try (InputStream is = this.getResourceStream("empty-content.xml");){
                IOUtils.copy(is, (OutputStream)this.zipOutputStream);
            }
        }
        this.zipOutputStream.closeEntry();
    }

    private void zipStyles() throws IOException {
        OdSource stylesOdSource = this.odZip.stylesOdSource();
        ZipEntry zipEntry = new ZipEntry("styles.xml");
        this.zipOutputStream.putNextEntry(zipEntry);
        if (stylesOdSource != null) {
            stylesOdSource.writeStream(this.zipOutputStream);
        } else {
            try (InputStream is = this.getResourceStream("empty-styles.xml");){
                IOUtils.copy(is, (OutputStream)this.zipOutputStream);
            }
        }
        this.zipOutputStream.closeEntry();
    }

    private void zipSettings() throws IOException {
        OdSource settingsOdSource = this.odZip.settingsOdSource();
        if (settingsOdSource == null) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry("settings.xml");
        this.zipOutputStream.putNextEntry(zipEntry);
        settingsOdSource.writeStream(this.zipOutputStream);
        this.zipOutputStream.closeEntry();
    }

    private void zipPictures() throws IOException {
        Pictures pictures = this.odZip.pictures();
        if (pictures == null) {
            return;
        }
        for (Pictures.Entry picture : pictures.getEntryList()) {
            ZipEntry zipEntry = new ZipEntry(picture.getHref());
            this.zipOutputStream.putNextEntry(zipEntry);
            picture.getOdSource().writeStream(this.zipOutputStream);
        }
    }

    private InputStream getResourceStream(String name) {
        InputStream inputStream = this.getClass().getResourceAsStream("resources/" + name);
        if (inputStream == null) {
            throw new InternalResourceException("resources/" + name);
        }
        return inputStream;
    }

    private static String getMediaType(short odType) {
        switch (odType) {
            case 1: {
                return "application/vnd.oasis.opendocument.text";
            }
            case 2: {
                return "application/vnd.oasis.opendocument.spreadsheet";
            }
        }
        throw new SwitchException("unknown odType = " + odType);
    }

    private static class ManifestXMLPart
    extends XMLPart {
        private final OdZip odZip;

        private ManifestXMLPart(XMLWriter xmlWriter, OdZip odZip) {
            super(xmlWriter);
            this.odZip = odZip;
        }

        public void writeManifest() throws IOException {
            Pictures pictures;
            this.startOpenTag("manifest:manifest");
            this.addAttribute("xmlns:manifest", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
            this.endOpenTag();
            this.appendFileEntry(OdZipEngine.getMediaType(this.odZip.odType()), "/");
            this.appendFileEntry("text/xml", "content.xml");
            this.appendFileEntry("text/xml", "styles.xml");
            OdSource settingsOdSource = this.odZip.settingsOdSource();
            if (settingsOdSource != null) {
                this.appendFileEntry("text/xml", "settings.xml");
            }
            if ((pictures = this.odZip.pictures()) != null) {
                for (Pictures.Entry picture : pictures.getEntryList()) {
                    this.appendFileEntry("", picture.getHref());
                }
            }
            this.closeTag("manifest:manifest");
        }

        private void appendFileEntry(String mediaType, String fullPath) throws IOException {
            this.startOpenTag("manifest:file-entry");
            this.addAttribute("manifest:media-type", mediaType);
            this.addAttribute("manifest:full-path", fullPath);
            this.closeEmptyTag();
        }
    }
}

