/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.storage;

import java.io.IOException;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class RedacteurStorageXMLPart
extends XMLPart {
    public RedacteurStorageXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void appendRedacteur(Redacteur redacteur) throws IOException {
        this.openTag("redacteur");
        this.appendPersonCore(redacteur.getPersonCore());
        EmailCore emailCore = redacteur.getEmailCore();
        if (emailCore != null) {
            this.appendEmailCore(emailCore);
        }
        AttributeUtils.addAttributes(this, redacteur.getAttributes());
        this.closeTag("redacteur");
    }

    private void appendPersonCore(PersonCore personCore) throws IOException {
        this.startOpenTag("person-core");
        if (personCore.isSurnameFirst()) {
            this.addAttribute("surname-first", "true");
        }
        this.addAttribute("surname", personCore.getSurname());
        this.addAttribute("forename", personCore.getForename());
        this.addAttribute("nonlatin", personCore.getNonlatin());
        this.closeEmptyTag();
    }

    private void appendEmailCore(EmailCore emailCore) throws IOException {
        this.startOpenTag("email-core");
        this.addAttribute("addr-spec", emailCore.getAddrSpec());
        this.addAttribute("real-name", emailCore.getRealName());
        this.closeEmptyTag();
    }
}

